/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OAuth2ErrorCode {
    TOKEN_EXPIRED("TOKEN_EXPIRED"),
    USER_CREDENTIALS_CHANGED("USER_CREDENTIALS_CHANGED"),
    INSUFFICIENT_PERMISSIONS("INSUFFICIENT_PERMISSIONS"),
    AUTHCODE_EXPIRED("AUTHCODE_EXPIRED"),
    SERVER_ERROR("server_error"),
    INVALID_REQUEST("INVALID_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OAuth2ErrorCode> VALUE_MAP;
    private final String value;

    private OAuth2ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuth2ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuth2ErrorCode> knownValues() {
        EnumSet<OAuth2ErrorCode> knownValues = EnumSet.allOf(OAuth2ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OAuth2ErrorCode.class, OAuth2ErrorCode::toString);
    }
}

