/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.signin.internal.AccessTokenManager;
import software.amazon.awssdk.services.signin.internal.LoginAccessToken;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class OnDiskTokenManager
implements AccessTokenManager {
    private final JsonNodeParser jsonParser = JsonNodeParser.builder().removeErrorLocations(true).build();
    private final Path tokenLocation;

    private OnDiskTokenManager(Path cacheLocation, String loginSession) {
        Validate.paramNotNull((Object)cacheLocation, (String)"cacheLocation");
        Validate.paramNotBlank((CharSequence)loginSession, (String)"loginSession");
        String cacheKey = this.deriveCacheKey(loginSession);
        this.tokenLocation = cacheLocation.resolve(cacheKey + ".json");
    }

    private String deriveCacheKey(String loginSession) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-256");
            sha1.update(loginSession.getBytes(StandardCharsets.UTF_8));
            return BinaryUtils.toHex((byte[])sha1.digest()).toLowerCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException e) {
            throw SdkClientException.create((String)"Unable to derive cache key", (Throwable)e);
        }
    }

    public static OnDiskTokenManager create(Path cacheLocation, String loginSession) {
        return new OnDiskTokenManager(cacheLocation, loginSession);
    }

    @Override
    public Optional<LoginAccessToken> loadToken() {
        Optional<LoginAccessToken> optional;
        block9: {
            if (!Files.exists(this.tokenLocation, new LinkOption[0])) {
                return Optional.empty();
            }
            InputStream cachedTokenStream = Files.newInputStream(this.tokenLocation, new OpenOption[0]);
            try {
                String content = IoUtils.toUtf8String((InputStream)cachedTokenStream);
                optional = Optional.of(this.unmarshalToken(content));
                if (cachedTokenStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cachedTokenStream != null) {
                        try {
                            cachedTokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    throw SdkClientException.create((String)("Failed to load cached token at " + this.tokenLocation), (Throwable)e);
                }
            }
            cachedTokenStream.close();
        }
        return optional;
    }

    @Override
    public void storeToken(LoginAccessToken token) {
        try {
            Path temp = Files.createTempFile(this.tokenLocation.getParent(), "token-", ".tmp", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(temp, new OpenOption[0]);){
                os.write(this.marshalToken(token));
            }
            Files.move(temp, this.tokenLocation, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException | UncheckedIOException e) {
            throw SdkClientException.create((String)("Unable to write token to location " + this.tokenLocation), (Throwable)e);
        }
    }

    public void close() {
    }

    private LoginAccessToken unmarshalToken(String contents) {
        JsonNode node = this.jsonParser.parse(contents);
        LoginAccessToken.Builder tokenBuilder = LoginAccessToken.builder();
        JsonNode accessToken = (JsonNode)node.field("accessToken").orElseThrow(() -> SdkClientException.create((String)"required member 'accessToken' not found"));
        AwsSessionCredentials awsSessionCredentials = OnDiskTokenManager.unmarshalAccessTokenCredentials(accessToken);
        tokenBuilder.accessToken(awsSessionCredentials);
        String clientId = node.field("clientId").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'clientId' not found"));
        tokenBuilder.clientId(clientId);
        String dpopKey = node.field("dpopKey").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'dpopKey' not found"));
        tokenBuilder.dpopKey(dpopKey);
        String refreshToken = node.field("refreshToken").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'refreshToken' not found"));
        tokenBuilder.refreshToken(refreshToken);
        node.field("tokenType").map(JsonNode::text).ifPresent(tokenBuilder::tokenType);
        node.field("identityToken").map(JsonNode::text).ifPresent(tokenBuilder::identityToken);
        return tokenBuilder.build();
    }

    private static AwsSessionCredentials unmarshalAccessTokenCredentials(JsonNode accessToken) {
        AwsSessionCredentials.Builder awsSessionCredentials = AwsSessionCredentials.builder();
        String accessKeyId = accessToken.field("accessKeyId").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'accessKeyId' not found"));
        awsSessionCredentials.accessKeyId(accessKeyId);
        String secretAccessKey = accessToken.field("secretAccessKey").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'secretAccessKey' not found"));
        awsSessionCredentials.secretAccessKey(secretAccessKey);
        String sessionToken = accessToken.field("sessionToken").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'sessionToken' not found"));
        awsSessionCredentials.sessionToken(sessionToken);
        String expiresAt = accessToken.field("expiresAt").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'expiresAt' not found"));
        awsSessionCredentials.expirationTime(Instant.parse(expiresAt));
        String accountId = accessToken.field("accountId").map(JsonNode::text).orElseThrow(() -> SdkClientException.create((String)"required member 'accountId' not found"));
        awsSessionCredentials.accountId(accountId);
        return awsSessionCredentials.build();
    }

    private byte[] marshalToken(LoginAccessToken token) {
        try (JsonWriter jsonWriter = JsonWriter.create();){
            jsonWriter.writeStartObject();
            jsonWriter.writeFieldName("accessToken");
            jsonWriter.writeStartObject();
            jsonWriter.writeFieldName("accessKeyId");
            jsonWriter.writeValue(token.getAccessToken().accessKeyId());
            jsonWriter.writeFieldName("secretAccessKey");
            jsonWriter.writeValue(token.getAccessToken().secretAccessKey());
            jsonWriter.writeFieldName("sessionToken");
            jsonWriter.writeValue(token.getAccessToken().sessionToken());
            jsonWriter.writeFieldName("accountId");
            jsonWriter.writeValue((String)token.getAccessToken().accountId().orElseThrow(() -> SdkClientException.create((String)"required member 'accountId' not found")));
            jsonWriter.writeFieldName("expiresAt");
            jsonWriter.writeValue(DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)token.getAccessToken().expirationTime().orElseThrow(() -> SdkClientException.create((String)"required member 'expiresAt' not found"))));
            jsonWriter.writeEndObject();
            if (token.getTokenType() != null) {
                jsonWriter.writeFieldName("tokenType");
                jsonWriter.writeValue(token.getTokenType());
            }
            if (token.getRefreshToken() != null) {
                jsonWriter.writeFieldName("refreshToken");
                jsonWriter.writeValue(token.getRefreshToken());
            }
            if (token.getIdentityToken() != null) {
                jsonWriter.writeFieldName("identityToken");
                jsonWriter.writeValue(token.getIdentityToken());
            }
            if (token.getClientId() != null) {
                jsonWriter.writeFieldName("clientId");
                jsonWriter.writeValue(token.getClientId());
            }
            if (token.getDpopKey() != null) {
                jsonWriter.writeFieldName("dpopKey");
                jsonWriter.writeValue(token.getDpopKey());
            }
            jsonWriter.writeEndObject();
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }
}

