/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public class LoginAccessToken
implements ToCopyableBuilder<Builder, LoginAccessToken> {
    private final AwsSessionCredentials accessToken;
    private final String tokenType;
    private final String refreshToken;
    private final String identityToken;
    private final String clientId;
    private final String dpopKey;

    private LoginAccessToken(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.identityToken = builder.identityToken;
        this.clientId = builder.clientId;
        this.dpopKey = builder.dpopKey;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public AwsSessionCredentials getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIdentityToken() {
        return this.identityToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDpopKey() {
        return this.dpopKey;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginAccessToken that = (LoginAccessToken)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.tokenType, that.tokenType) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.identityToken, that.identityToken) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.dpopKey, that.dpopKey);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accessToken);
        result = 31 * result + Objects.hashCode(this.tokenType);
        result = 31 * result + Objects.hashCode(this.refreshToken);
        result = 31 * result + Objects.hashCode(this.identityToken);
        result = 31 * result + Objects.hashCode(this.clientId);
        result = 31 * result + Objects.hashCode(this.dpopKey);
        return result;
    }

    public String toString() {
        return "LoginAccessToken{accessToken=" + this.accessToken + ", tokenType='" + this.tokenType + '\'' + ", identityToken='" + this.identityToken + '\'' + ", clientId='" + this.clientId + '\'' + '}';
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    protected static class BuilderImpl
    implements Builder {
        private AwsSessionCredentials accessToken;
        private String tokenType;
        private String refreshToken;
        private String identityToken;
        private String clientId;
        private String dpopKey;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginAccessToken loginAccessToken) {
            this.accessToken = loginAccessToken.accessToken.toBuilder().build();
            this.tokenType = loginAccessToken.tokenType;
            this.refreshToken = loginAccessToken.refreshToken;
            this.identityToken = loginAccessToken.identityToken;
            this.clientId = loginAccessToken.clientId;
            this.dpopKey = loginAccessToken.dpopKey;
        }

        @Override
        public Builder accessToken(AwsSessionCredentials accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Override
        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        public Builder identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        @Override
        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public Builder dpopKey(String dpopKey) {
            this.dpopKey = dpopKey;
            return this;
        }

        @Override
        public LoginAccessToken build() {
            return new LoginAccessToken(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoginAccessToken> {
        public Builder accessToken(AwsSessionCredentials var1);

        public Builder tokenType(String var1);

        public Builder refreshToken(String var1);

        public Builder identityToken(String var1);

        public Builder clientId(String var1);

        public Builder dpopKey(String var1);

        public LoginAccessToken build();
    }
}

