/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningProfilesRequest extends SignerRequest implements
        ToCopyableBuilder<ListSigningProfilesRequest.Builder, ListSigningProfilesRequest> {
    private static final SdkField<Boolean> INCLUDE_CANCELED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeCanceled").getter(getter(ListSigningProfilesRequest::includeCanceled))
            .setter(setter(Builder::includeCanceled))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeCanceled").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSigningProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSigningProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(ListSigningProfilesRequest::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platformId").build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(ListSigningProfilesRequest::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_CANCELED_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PLATFORM_ID_FIELD, STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean includeCanceled;

    private final Integer maxResults;

    private final String nextToken;

    private final String platformId;

    private final List<String> statuses;

    private ListSigningProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.includeCanceled = builder.includeCanceled;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.platformId = builder.platformId;
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * Designates whether to include profiles with the status of <code>CANCELED</code>.
     * </p>
     * 
     * @return Designates whether to include profiles with the status of <code>CANCELED</code>.
     */
    public final Boolean includeCanceled() {
        return includeCanceled;
    }

    /**
     * <p>
     * The maximum number of profiles to be returned.
     * </p>
     * 
     * @return The maximum number of profiles to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Value for specifying the next set of paginated results to return. After you receive a response with truncated
     * results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the
     * response that you just received.
     * </p>
     * 
     * @return Value for specifying the next set of paginated results to return. After you receive a response with
     *         truncated results, use this parameter in a subsequent request. Set it to the value of
     *         <code>nextToken</code> from the response that you just received.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filters results to return only signing jobs initiated for a specified signing platform.
     * </p>
     * 
     * @return Filters results to return only signing jobs initiated for a specified signing platform.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * Filters results to return only signing jobs with statuses in the specified list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filters results to return only signing jobs with statuses in the specified list.
     */
    public final List<SigningProfileStatus> statuses() {
        return StatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters results to return only signing jobs with statuses in the specified list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filters results to return only signing jobs with statuses in the specified list.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeCanceled());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningProfilesRequest)) {
            return false;
        }
        ListSigningProfilesRequest other = (ListSigningProfilesRequest) obj;
        return Objects.equals(includeCanceled(), other.includeCanceled()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(platformId(), other.platformId())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSigningProfilesRequest").add("IncludeCanceled", includeCanceled())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("PlatformId", platformId())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeCanceled":
            return Optional.ofNullable(clazz.cast(includeCanceled()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("includeCanceled", INCLUDE_CANCELED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("platformId", PLATFORM_ID_FIELD);
        map.put("statuses", STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSigningProfilesRequest, T> g) {
        return obj -> g.apply((ListSigningProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningProfilesRequest> {
        /**
         * <p>
         * Designates whether to include profiles with the status of <code>CANCELED</code>.
         * </p>
         * 
         * @param includeCanceled
         *        Designates whether to include profiles with the status of <code>CANCELED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCanceled(Boolean includeCanceled);

        /**
         * <p>
         * The maximum number of profiles to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of profiles to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Value for specifying the next set of paginated results to return. After you receive a response with truncated
         * results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the
         * response that you just received.
         * </p>
         * 
         * @param nextToken
         *        Value for specifying the next set of paginated results to return. After you receive a response with
         *        truncated results, use this parameter in a subsequent request. Set it to the value of
         *        <code>nextToken</code> from the response that you just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters results to return only signing jobs initiated for a specified signing platform.
         * </p>
         * 
         * @param platformId
         *        Filters results to return only signing jobs initiated for a specified signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * Filters results to return only signing jobs with statuses in the specified list.
         * </p>
         * 
         * @param statuses
         *        Filters results to return only signing jobs with statuses in the specified list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * Filters results to return only signing jobs with statuses in the specified list.
         * </p>
         * 
         * @param statuses
         *        Filters results to return only signing jobs with statuses in the specified list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * Filters results to return only signing jobs with statuses in the specified list.
         * </p>
         * 
         * @param statuses
         *        Filters results to return only signing jobs with statuses in the specified list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<SigningProfileStatus> statuses);

        /**
         * <p>
         * Filters results to return only signing jobs with statuses in the specified list.
         * </p>
         * 
         * @param statuses
         *        Filters results to return only signing jobs with statuses in the specified list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(SigningProfileStatus... statuses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private Boolean includeCanceled;

        private Integer maxResults;

        private String nextToken;

        private String platformId;

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningProfilesRequest model) {
            super(model);
            includeCanceled(model.includeCanceled);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            platformId(model.platformId);
            statusesWithStrings(model.statuses);
        }

        public final Boolean getIncludeCanceled() {
            return includeCanceled;
        }

        public final void setIncludeCanceled(Boolean includeCanceled) {
            this.includeCanceled = includeCanceled;
        }

        @Override
        public final Builder includeCanceled(Boolean includeCanceled) {
            this.includeCanceled = includeCanceled;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = StatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = StatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<SigningProfileStatus> statuses) {
            this.statuses = StatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(SigningProfileStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSigningProfilesRequest build() {
            return new ListSigningProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
