/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSigningProfileResponse extends SignerResponse implements
        ToCopyableBuilder<GetSigningProfileResponse.Builder, GetSigningProfileResponse> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(GetSigningProfileResponse::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(GetSigningProfileResponse::profileVersion))
            .setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<String> PROFILE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersionArn").getter(getter(GetSigningProfileResponse::profileVersionArn))
            .setter(setter(Builder::profileVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersionArn").build()).build();

    private static final SdkField<SigningProfileRevocationRecord> REVOCATION_RECORD_FIELD = SdkField
            .<SigningProfileRevocationRecord> builder(MarshallingType.SDK_POJO).memberName("revocationRecord")
            .getter(getter(GetSigningProfileResponse::revocationRecord)).setter(setter(Builder::revocationRecord))
            .constructor(SigningProfileRevocationRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationRecord").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).memberName("signingMaterial")
            .getter(getter(GetSigningProfileResponse::signingMaterial)).setter(setter(Builder::signingMaterial))
            .constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(GetSigningProfileResponse::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformDisplayName").getter(getter(GetSigningProfileResponse::platformDisplayName))
            .setter(setter(Builder::platformDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build())
            .build();

    private static final SdkField<SignatureValidityPeriod> SIGNATURE_VALIDITY_PERIOD_FIELD = SdkField
            .<SignatureValidityPeriod> builder(MarshallingType.SDK_POJO).memberName("signatureValidityPeriod")
            .getter(getter(GetSigningProfileResponse::signatureValidityPeriod)).setter(setter(Builder::signatureValidityPeriod))
            .constructor(SignatureValidityPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValidityPeriod").build())
            .build();

    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField
            .<SigningPlatformOverrides> builder(MarshallingType.SDK_POJO).memberName("overrides")
            .getter(getter(GetSigningProfileResponse::overrides)).setter(setter(Builder::overrides))
            .constructor(SigningPlatformOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()).build();

    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("signingParameters")
            .getter(getter(GetSigningProfileResponse::signingParameters))
            .setter(setter(Builder::signingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSigningProfileResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetSigningProfileResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetSigningProfileResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetSigningProfileResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            PROFILE_VERSION_FIELD, PROFILE_VERSION_ARN_FIELD, REVOCATION_RECORD_FIELD, SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD,
            PLATFORM_DISPLAY_NAME_FIELD, SIGNATURE_VALIDITY_PERIOD_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileName;

    private final String profileVersion;

    private final String profileVersionArn;

    private final SigningProfileRevocationRecord revocationRecord;

    private final SigningMaterial signingMaterial;

    private final String platformId;

    private final String platformDisplayName;

    private final SignatureValidityPeriod signatureValidityPeriod;

    private final SigningPlatformOverrides overrides;

    private final Map<String, String> signingParameters;

    private final String status;

    private final String statusReason;

    private final String arn;

    private final Map<String, String> tags;

    private GetSigningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.profileVersionArn = builder.profileVersionArn;
        this.revocationRecord = builder.revocationRecord;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.signatureValidityPeriod = builder.signatureValidityPeriod;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the target signing profile.
     * </p>
     * 
     * @return The name of the target signing profile.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The current version of the signing profile.
     * </p>
     * 
     * @return The current version of the signing profile.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The signing profile ARN, including the profile version.
     * </p>
     * 
     * @return The signing profile ARN, including the profile version.
     */
    public final String profileVersionArn() {
        return profileVersionArn;
    }

    /**
     * Returns the value of the RevocationRecord property for this object.
     * 
     * @return The value of the RevocationRecord property for this object.
     */
    public final SigningProfileRevocationRecord revocationRecord() {
        return revocationRecord;
    }

    /**
     * <p>
     * The ARN of the certificate that the target profile uses for signing operations.
     * </p>
     * 
     * @return The ARN of the certificate that the target profile uses for signing operations.
     */
    public final SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The ID of the platform that is used by the target signing profile.
     * </p>
     * 
     * @return The ID of the platform that is used by the target signing profile.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * A human-readable name for the signing platform associated with the signing profile.
     * </p>
     * 
     * @return A human-readable name for the signing platform associated with the signing profile.
     */
    public final String platformDisplayName() {
        return platformDisplayName;
    }

    /**
     * Returns the value of the SignatureValidityPeriod property for this object.
     * 
     * @return The value of the SignatureValidityPeriod property for this object.
     */
    public final SignatureValidityPeriod signatureValidityPeriod() {
        return signatureValidityPeriod;
    }

    /**
     * <p>
     * A list of overrides applied by the target signing profile for signing operations.
     * </p>
     * 
     * @return A list of overrides applied by the target signing profile for signing operations.
     */
    public final SigningPlatformOverrides overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the SigningParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSigningParameters() {
        return signingParameters != null && !(signingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs for signing operations that is attached to the target signing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSigningParameters} method.
     * </p>
     * 
     * @return A map of key-value pairs for signing operations that is attached to the target signing profile.
     */
    public final Map<String, String> signingParameters() {
        return signingParameters;
    }

    /**
     * <p>
     * The status of the target signing profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the target signing profile.
     * @see SigningProfileStatus
     */
    public final SigningProfileStatus status() {
        return SigningProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the target signing profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the target signing profile.
     * @see SigningProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Reason for the status of the target signing profile.
     * </p>
     * 
     * @return Reason for the status of the target signing profile.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the signing profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the signing profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the signing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the signing profile.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(revocationRecord());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(signatureValidityPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasSigningParameters() ? signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSigningProfileResponse)) {
            return false;
        }
        GetSigningProfileResponse other = (GetSigningProfileResponse) obj;
        return Objects.equals(profileName(), other.profileName()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(profileVersionArn(), other.profileVersionArn())
                && Objects.equals(revocationRecord(), other.revocationRecord())
                && Objects.equals(signingMaterial(), other.signingMaterial()) && Objects.equals(platformId(), other.platformId())
                && Objects.equals(platformDisplayName(), other.platformDisplayName())
                && Objects.equals(signatureValidityPeriod(), other.signatureValidityPeriod())
                && Objects.equals(overrides(), other.overrides()) && hasSigningParameters() == other.hasSigningParameters()
                && Objects.equals(signingParameters(), other.signingParameters())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(arn(), other.arn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSigningProfileResponse").add("ProfileName", profileName())
                .add("ProfileVersion", profileVersion()).add("ProfileVersionArn", profileVersionArn())
                .add("RevocationRecord", revocationRecord()).add("SigningMaterial", signingMaterial())
                .add("PlatformId", platformId()).add("PlatformDisplayName", platformDisplayName())
                .add("SignatureValidityPeriod", signatureValidityPeriod()).add("Overrides", overrides())
                .add("SigningParameters", hasSigningParameters() ? signingParameters() : null).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("Arn", arn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "profileVersionArn":
            return Optional.ofNullable(clazz.cast(profileVersionArn()));
        case "revocationRecord":
            return Optional.ofNullable(clazz.cast(revocationRecord()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "platformDisplayName":
            return Optional.ofNullable(clazz.cast(platformDisplayName()));
        case "signatureValidityPeriod":
            return Optional.ofNullable(clazz.cast(signatureValidityPeriod()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "signingParameters":
            return Optional.ofNullable(clazz.cast(signingParameters()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profileName", PROFILE_NAME_FIELD);
        map.put("profileVersion", PROFILE_VERSION_FIELD);
        map.put("profileVersionArn", PROFILE_VERSION_ARN_FIELD);
        map.put("revocationRecord", REVOCATION_RECORD_FIELD);
        map.put("signingMaterial", SIGNING_MATERIAL_FIELD);
        map.put("platformId", PLATFORM_ID_FIELD);
        map.put("platformDisplayName", PLATFORM_DISPLAY_NAME_FIELD);
        map.put("signatureValidityPeriod", SIGNATURE_VALIDITY_PERIOD_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("signingParameters", SIGNING_PARAMETERS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSigningProfileResponse, T> g) {
        return obj -> g.apply((GetSigningProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSigningProfileResponse> {
        /**
         * <p>
         * The name of the target signing profile.
         * </p>
         * 
         * @param profileName
         *        The name of the target signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The current version of the signing profile.
         * </p>
         * 
         * @param profileVersion
         *        The current version of the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The signing profile ARN, including the profile version.
         * </p>
         * 
         * @param profileVersionArn
         *        The signing profile ARN, including the profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersionArn(String profileVersionArn);

        /**
         * Sets the value of the RevocationRecord property for this object.
         *
         * @param revocationRecord
         *        The new value for the RevocationRecord property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationRecord(SigningProfileRevocationRecord revocationRecord);

        /**
         * Sets the value of the RevocationRecord property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SigningProfileRevocationRecord.Builder}
         * avoiding the need to create one manually via {@link SigningProfileRevocationRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningProfileRevocationRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #revocationRecord(SigningProfileRevocationRecord)}.
         * 
         * @param revocationRecord
         *        a consumer that will call methods on {@link SigningProfileRevocationRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revocationRecord(SigningProfileRevocationRecord)
         */
        default Builder revocationRecord(Consumer<SigningProfileRevocationRecord.Builder> revocationRecord) {
            return revocationRecord(SigningProfileRevocationRecord.builder().applyMutation(revocationRecord).build());
        }

        /**
         * <p>
         * The ARN of the certificate that the target profile uses for signing operations.
         * </p>
         * 
         * @param signingMaterial
         *        The ARN of the certificate that the target profile uses for signing operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * The ARN of the certificate that the target profile uses for signing operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningMaterial.Builder} avoiding the
         * need to create one manually via {@link SigningMaterial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The ID of the platform that is used by the target signing profile.
         * </p>
         * 
         * @param platformId
         *        The ID of the platform that is used by the target signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * A human-readable name for the signing platform associated with the signing profile.
         * </p>
         * 
         * @param platformDisplayName
         *        A human-readable name for the signing platform associated with the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDisplayName(String platformDisplayName);

        /**
         * Sets the value of the SignatureValidityPeriod property for this object.
         *
         * @param signatureValidityPeriod
         *        The new value for the SignatureValidityPeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod);

        /**
         * Sets the value of the SignatureValidityPeriod property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SignatureValidityPeriod.Builder} avoiding
         * the need to create one manually via {@link SignatureValidityPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignatureValidityPeriod.Builder#build()} is called immediately
         * and its result is passed to {@link #signatureValidityPeriod(SignatureValidityPeriod)}.
         * 
         * @param signatureValidityPeriod
         *        a consumer that will call methods on {@link SignatureValidityPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signatureValidityPeriod(SignatureValidityPeriod)
         */
        default Builder signatureValidityPeriod(Consumer<SignatureValidityPeriod.Builder> signatureValidityPeriod) {
            return signatureValidityPeriod(SignatureValidityPeriod.builder().applyMutation(signatureValidityPeriod).build());
        }

        /**
         * <p>
         * A list of overrides applied by the target signing profile for signing operations.
         * </p>
         * 
         * @param overrides
         *        A list of overrides applied by the target signing profile for signing operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(SigningPlatformOverrides overrides);

        /**
         * <p>
         * A list of overrides applied by the target signing profile for signing operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningPlatformOverrides.Builder}
         * avoiding the need to create one manually via {@link SigningPlatformOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningPlatformOverrides.Builder#build()} is called immediately
         * and its result is passed to {@link #overrides(SigningPlatformOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link SigningPlatformOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(SigningPlatformOverrides)
         */
        default Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return overrides(SigningPlatformOverrides.builder().applyMutation(overrides).build());
        }

        /**
         * <p>
         * A map of key-value pairs for signing operations that is attached to the target signing profile.
         * </p>
         * 
         * @param signingParameters
         *        A map of key-value pairs for signing operations that is attached to the target signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingParameters(Map<String, String> signingParameters);

        /**
         * <p>
         * The status of the target signing profile.
         * </p>
         * 
         * @param status
         *        The status of the target signing profile.
         * @see SigningProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the target signing profile.
         * </p>
         * 
         * @param status
         *        The status of the target signing profile.
         * @see SigningProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningProfileStatus
         */
        Builder status(SigningProfileStatus status);

        /**
         * <p>
         * Reason for the status of the target signing profile.
         * </p>
         * 
         * @param statusReason
         *        Reason for the status of the target signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the signing profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of tags associated with the signing profile.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String profileName;

        private String profileVersion;

        private String profileVersionArn;

        private SigningProfileRevocationRecord revocationRecord;

        private SigningMaterial signingMaterial;

        private String platformId;

        private String platformDisplayName;

        private SignatureValidityPeriod signatureValidityPeriod;

        private SigningPlatformOverrides overrides;

        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String statusReason;

        private String arn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSigningProfileResponse model) {
            super(model);
            profileName(model.profileName);
            profileVersion(model.profileVersion);
            profileVersionArn(model.profileVersionArn);
            revocationRecord(model.revocationRecord);
            signingMaterial(model.signingMaterial);
            platformId(model.platformId);
            platformDisplayName(model.platformDisplayName);
            signatureValidityPeriod(model.signatureValidityPeriod);
            overrides(model.overrides);
            signingParameters(model.signingParameters);
            status(model.status);
            statusReason(model.statusReason);
            arn(model.arn);
            tags(model.tags);
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getProfileVersionArn() {
            return profileVersionArn;
        }

        public final void setProfileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
        }

        @Override
        public final Builder profileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
            return this;
        }

        public final SigningProfileRevocationRecord.Builder getRevocationRecord() {
            return revocationRecord != null ? revocationRecord.toBuilder() : null;
        }

        public final void setRevocationRecord(SigningProfileRevocationRecord.BuilderImpl revocationRecord) {
            this.revocationRecord = revocationRecord != null ? revocationRecord.build() : null;
        }

        @Override
        public final Builder revocationRecord(SigningProfileRevocationRecord revocationRecord) {
            this.revocationRecord = revocationRecord;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getPlatformDisplayName() {
            return platformDisplayName;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final SignatureValidityPeriod.Builder getSignatureValidityPeriod() {
            return signatureValidityPeriod != null ? signatureValidityPeriod.toBuilder() : null;
        }

        public final void setSignatureValidityPeriod(SignatureValidityPeriod.BuilderImpl signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod != null ? signatureValidityPeriod.build() : null;
        }

        @Override
        public final Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod;
            return this;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final Map<String, String> getSigningParameters() {
            if (signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return signingParameters;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSigningProfileResponse build() {
            return new GetSigningProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
