/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.MetadataCopier;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignPayloadResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, SignPayloadResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(SignPayloadResponse.getter(SignPayloadResponse::jobId)).setter(SignPayloadResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobOwner").getter(SignPayloadResponse.getter(SignPayloadResponse::jobOwner)).setter(SignPayloadResponse.setter(Builder::jobOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(SignPayloadResponse.getter(SignPayloadResponse::metadata)).setter(SignPayloadResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SdkBytes> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("signature").getter(SignPayloadResponse.getter(SignPayloadResponse::signature)).setter(SignPayloadResponse.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_OWNER_FIELD, METADATA_FIELD, SIGNATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobId", JOB_ID_FIELD);
            this.put("jobOwner", JOB_OWNER_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("signature", SIGNATURE_FIELD);
        }
    });
    private final String jobId;
    private final String jobOwner;
    private final Map<String, String> metadata;
    private final SdkBytes signature;

    private SignPayloadResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobOwner = builder.jobOwner;
        this.metadata = builder.metadata;
        this.signature = builder.signature;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobOwner() {
        return this.jobOwner;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final SdkBytes signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignPayloadResponse)) {
            return false;
        }
        SignPayloadResponse other = (SignPayloadResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobOwner(), other.jobOwner()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.signature(), other.signature());
    }

    public final String toString() {
        return ToString.builder((String)"SignPayloadResponse").add("JobId", (Object)this.jobId()).add("JobOwner", (Object)this.jobOwner()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Signature", (Object)this.signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobOwner": {
                return Optional.ofNullable(clazz.cast(this.jobOwner()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SignPayloadResponse, T> g) {
        return obj -> g.apply((SignPayloadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobOwner;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private SdkBytes signature;

        private BuilderImpl() {
        }

        private BuilderImpl(SignPayloadResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobOwner(model.jobOwner);
            this.metadata(model.metadata);
            this.signature(model.signature);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobOwner() {
            return this.jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final ByteBuffer getSignature() {
            return this.signature == null ? null : this.signature.asByteBuffer();
        }

        public final void setSignature(ByteBuffer signature) {
            this.signature(signature == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)signature));
        }

        @Override
        public final Builder signature(SdkBytes signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public SignPayloadResponse build() {
            return new SignPayloadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignPayloadResponse> {
        public Builder jobId(String var1);

        public Builder jobOwner(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder signature(SdkBytes var1);
    }
}

