/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddProfilePermissionRequest extends SignerRequest implements
        ToCopyableBuilder<AddProfilePermissionRequest.Builder, AddProfilePermissionRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(AddProfilePermissionRequest::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(AddProfilePermissionRequest::profileVersion))
            .setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(AddProfilePermissionRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(AddProfilePermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(AddProfilePermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(AddProfilePermissionRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            PROFILE_VERSION_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, REVISION_ID_FIELD, STATEMENT_ID_FIELD));

    private final String profileName;

    private final String profileVersion;

    private final String action;

    private final String principal;

    private final String revisionId;

    private final String statementId;

    private AddProfilePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.action = builder.action;
        this.principal = builder.principal;
        this.revisionId = builder.revisionId;
        this.statementId = builder.statementId;
    }

    /**
     * <p>
     * The human-readable name of the signing profile.
     * </p>
     * 
     * @return The human-readable name of the signing profile.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The version of the signing profile.
     * </p>
     * 
     * @return The version of the signing profile.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The AWS Signer action permitted as part of cross-account permissions.
     * </p>
     * 
     * @return The AWS Signer action permitted as part of cross-account permissions.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.
     * </p>
     * 
     * @return The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * A unique identifier for the current profile revision.
     * </p>
     * 
     * @return A unique identifier for the current profile revision.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * A unique identifier for the cross-account permission statement.
     * </p>
     * 
     * @return A unique identifier for the cross-account permission statement.
     */
    public final String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddProfilePermissionRequest)) {
            return false;
        }
        AddProfilePermissionRequest other = (AddProfilePermissionRequest) obj;
        return Objects.equals(profileName(), other.profileName()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(action(), other.action()) && Objects.equals(principal(), other.principal())
                && Objects.equals(revisionId(), other.revisionId()) && Objects.equals(statementId(), other.statementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddProfilePermissionRequest").add("ProfileName", profileName())
                .add("ProfileVersion", profileVersion()).add("Action", action()).add("Principal", principal())
                .add("RevisionId", revisionId()).add("StatementId", statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddProfilePermissionRequest, T> g) {
        return obj -> g.apply((AddProfilePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddProfilePermissionRequest> {
        /**
         * <p>
         * The human-readable name of the signing profile.
         * </p>
         * 
         * @param profileName
         *        The human-readable name of the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The version of the signing profile.
         * </p>
         * 
         * @param profileVersion
         *        The version of the signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The AWS Signer action permitted as part of cross-account permissions.
         * </p>
         * 
         * @param action
         *        The AWS Signer action permitted as part of cross-account permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.
         * </p>
         * 
         * @param principal
         *        The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * A unique identifier for the current profile revision.
         * </p>
         * 
         * @param revisionId
         *        A unique identifier for the current profile revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * A unique identifier for the cross-account permission statement.
         * </p>
         * 
         * @param statementId
         *        A unique identifier for the cross-account permission statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private String profileName;

        private String profileVersion;

        private String action;

        private String principal;

        private String revisionId;

        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddProfilePermissionRequest model) {
            super(model);
            profileName(model.profileName);
            profileVersion(model.profileVersion);
            action(model.action);
            principal(model.principal);
            revisionId(model.revisionId);
            statementId(model.statementId);
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddProfilePermissionRequest build() {
            return new AddProfilePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
