/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignatureValidityPeriod;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningPlatformOverrides;
import software.amazon.awssdk.services.signer.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSigningProfileRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, PutSigningProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::profileName)).setter(PutSigningProfileRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingMaterial").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::signingMaterial)).setter(PutSigningProfileRequest.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<SignatureValidityPeriod> SIGNATURE_VALIDITY_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signatureValidityPeriod").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::signatureValidityPeriod)).setter(PutSigningProfileRequest.setter(Builder::signatureValidityPeriod)).constructor(SignatureValidityPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValidityPeriod").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::platformId)).setter(PutSigningProfileRequest.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::overrides)).setter(PutSigningProfileRequest.setter(Builder::overrides)).constructor(SigningPlatformOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signingParameters").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::signingParameters)).setter(PutSigningProfileRequest.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PutSigningProfileRequest.getter(PutSigningProfileRequest::tags)).setter(PutSigningProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, SIGNING_MATERIAL_FIELD, SIGNATURE_VALIDITY_PERIOD_FIELD, PLATFORM_ID_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, TAGS_FIELD));
    private final String profileName;
    private final SigningMaterial signingMaterial;
    private final SignatureValidityPeriod signatureValidityPeriod;
    private final String platformId;
    private final SigningPlatformOverrides overrides;
    private final Map<String, String> signingParameters;
    private final Map<String, String> tags;

    private PutSigningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.signingMaterial = builder.signingMaterial;
        this.signatureValidityPeriod = builder.signatureValidityPeriod;
        this.platformId = builder.platformId;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.tags = builder.tags;
    }

    public String profileName() {
        return this.profileName;
    }

    public SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public SignatureValidityPeriod signatureValidityPeriod() {
        return this.signatureValidityPeriod;
    }

    public String platformId() {
        return this.platformId;
    }

    public SigningPlatformOverrides overrides() {
        return this.overrides;
    }

    public boolean hasSigningParameters() {
        return this.signingParameters != null && !(this.signingParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureValidityPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningParameters() ? this.signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningProfileRequest)) {
            return false;
        }
        PutSigningProfileRequest other = (PutSigningProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.signatureValidityPeriod(), other.signatureValidityPeriod()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.overrides(), other.overrides()) && this.hasSigningParameters() == other.hasSigningParameters() && Objects.equals(this.signingParameters(), other.signingParameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PutSigningProfileRequest").add("ProfileName", (Object)this.profileName()).add("SigningMaterial", (Object)this.signingMaterial()).add("SignatureValidityPeriod", (Object)this.signatureValidityPeriod()).add("PlatformId", (Object)this.platformId()).add("Overrides", (Object)this.overrides()).add("SigningParameters", this.hasSigningParameters() ? this.signingParameters() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "signatureValidityPeriod": {
                return Optional.ofNullable(clazz.cast(this.signatureValidityPeriod()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSigningProfileRequest, T> g) {
        return obj -> g.apply((PutSigningProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private SigningMaterial signingMaterial;
        private SignatureValidityPeriod signatureValidityPeriod;
        private String platformId;
        private SigningPlatformOverrides overrides;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSigningProfileRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.signingMaterial(model.signingMaterial);
            this.signatureValidityPeriod(model.signatureValidityPeriod);
            this.platformId(model.platformId);
            this.overrides(model.overrides);
            this.signingParameters(model.signingParameters);
            this.tags(model.tags);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final SignatureValidityPeriod.Builder getSignatureValidityPeriod() {
            return this.signatureValidityPeriod != null ? this.signatureValidityPeriod.toBuilder() : null;
        }

        @Override
        public final Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod;
            return this;
        }

        public final void setSignatureValidityPeriod(SignatureValidityPeriod.BuilderImpl signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod != null ? signatureValidityPeriod.build() : null;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Map<String, String> getSigningParameters() {
            if (this.signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signingParameters;
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSigningProfileRequest build() {
            return new PutSigningProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSigningProfileRequest> {
        public Builder profileName(String var1);

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder signatureValidityPeriod(SignatureValidityPeriod var1);

        default public Builder signatureValidityPeriod(Consumer<SignatureValidityPeriod.Builder> signatureValidityPeriod) {
            return this.signatureValidityPeriod((SignatureValidityPeriod)((SignatureValidityPeriod.Builder)SignatureValidityPeriod.builder().applyMutation(signatureValidityPeriod)).build());
        }

        public Builder platformId(String var1);

        public Builder overrides(SigningPlatformOverrides var1);

        default public Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return this.overrides((SigningPlatformOverrides)((SigningPlatformOverrides.Builder)SigningPlatformOverrides.builder().applyMutation(overrides)).build());
        }

        public Builder signingParameters(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

