/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.SubResourceType;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVector;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVectorListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubResourceSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubResourceSummary.getter(SubResourceSummary::typeAsString)).setter(SubResourceSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubResourceSummary.getter(SubResourceSummary::id)).setter(SubResourceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<SummarizedAttackVector>> ATTACK_VECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SubResourceSummary.getter(SubResourceSummary::attackVectors)).setter(SubResourceSummary.setter(Builder::attackVectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackVectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummarizedAttackVector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SummarizedCounter>> COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SubResourceSummary.getter(SubResourceSummary::counters)).setter(SubResourceSummary.setter(Builder::counters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Counters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummarizedCounter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, ATTACK_VECTORS_FIELD, COUNTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;
    private final List<SummarizedAttackVector> attackVectors;
    private final List<SummarizedCounter> counters;

    private SubResourceSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.attackVectors = builder.attackVectors;
        this.counters = builder.counters;
    }

    public SubResourceType type() {
        return SubResourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public List<SummarizedAttackVector> attackVectors() {
        return this.attackVectors;
    }

    public List<SummarizedCounter> counters() {
        return this.counters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.attackVectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.counters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubResourceSummary)) {
            return false;
        }
        SubResourceSummary other = (SubResourceSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.attackVectors(), other.attackVectors()) && Objects.equals(this.counters(), other.counters());
    }

    public String toString() {
        return ToString.builder((String)"SubResourceSummary").add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("AttackVectors", this.attackVectors()).add("Counters", this.counters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "AttackVectors": {
                return Optional.ofNullable(clazz.cast(this.attackVectors()));
            }
            case "Counters": {
                return Optional.ofNullable(clazz.cast(this.counters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubResourceSummary, T> g) {
        return obj -> g.apply((SubResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private List<SummarizedAttackVector> attackVectors = DefaultSdkAutoConstructList.getInstance();
        private List<SummarizedCounter> counters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubResourceSummary model) {
            this.type(model.type);
            this.id(model.id);
            this.attackVectors(model.attackVectors);
            this.counters(model.counters);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SubResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<SummarizedAttackVector.Builder> getAttackVectors() {
            return this.attackVectors != null ? (Collection)this.attackVectors.stream().map(SummarizedAttackVector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackVectors(Collection<SummarizedAttackVector> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(SummarizedAttackVector ... attackVectors) {
            this.attackVectors(Arrays.asList(attackVectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(Consumer<SummarizedAttackVector.Builder> ... attackVectors) {
            this.attackVectors(Stream.of(attackVectors).map(c -> (SummarizedAttackVector)((SummarizedAttackVector.Builder)SummarizedAttackVector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttackVectors(Collection<SummarizedAttackVector.BuilderImpl> attackVectors) {
            this.attackVectors = SummarizedAttackVectorListCopier.copyFromBuilder(attackVectors);
        }

        public final Collection<SummarizedCounter.Builder> getCounters() {
            return this.counters != null ? (Collection)this.counters.stream().map(SummarizedCounter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder counters(Collection<SummarizedCounter> counters) {
            this.counters = SummarizedCounterListCopier.copy(counters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(SummarizedCounter ... counters) {
            this.counters(Arrays.asList(counters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder counters(Consumer<SummarizedCounter.Builder> ... counters) {
            this.counters(Stream.of(counters).map(c -> (SummarizedCounter)((SummarizedCounter.Builder)SummarizedCounter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCounters(Collection<SummarizedCounter.BuilderImpl> counters) {
            this.counters = SummarizedCounterListCopier.copyFromBuilder(counters);
        }

        public SubResourceSummary build() {
            return new SubResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubResourceSummary> {
        public Builder type(String var1);

        public Builder type(SubResourceType var1);

        public Builder id(String var1);

        public Builder attackVectors(Collection<SummarizedAttackVector> var1);

        public Builder attackVectors(SummarizedAttackVector ... var1);

        public Builder attackVectors(Consumer<SummarizedAttackVector.Builder> ... var1);

        public Builder counters(Collection<SummarizedCounter> var1);

        public Builder counters(SummarizedCounter ... var1);

        public Builder counters(Consumer<SummarizedCounter.Builder> ... var1);
    }
}

