/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAttackStatisticsResponse extends ShieldResponse implements
        ToCopyableBuilder<DescribeAttackStatisticsResponse.Builder, DescribeAttackStatisticsResponse> {
    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("TimeRange").getter(getter(DescribeAttackStatisticsResponse::timeRange))
            .setter(setter(Builder::timeRange)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final SdkField<List<AttackStatisticsDataItem>> DATA_ITEMS_FIELD = SdkField
            .<List<AttackStatisticsDataItem>> builder(MarshallingType.LIST)
            .memberName("DataItems")
            .getter(getter(DescribeAttackStatisticsResponse::dataItems))
            .setter(setter(Builder::dataItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttackStatisticsDataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttackStatisticsDataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD,
            DATA_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TimeRange timeRange;

    private final List<AttackStatisticsDataItem> dataItems;

    private DescribeAttackStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.timeRange = builder.timeRange;
        this.dataItems = builder.dataItems;
    }

    /**
     * <p>
     * The time range of the attack.
     * </p>
     * 
     * @return The time range of the attack.
     */
    public final TimeRange timeRange() {
        return timeRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataItems property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataItems() {
        return dataItems != null && !(dataItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data that describes the attacks detected during the time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataItems} method.
     * </p>
     * 
     * @return The data that describes the attacks detected during the time period.
     */
    public final List<AttackStatisticsDataItem> dataItems() {
        return dataItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataItems() ? dataItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAttackStatisticsResponse)) {
            return false;
        }
        DescribeAttackStatisticsResponse other = (DescribeAttackStatisticsResponse) obj;
        return Objects.equals(timeRange(), other.timeRange()) && hasDataItems() == other.hasDataItems()
                && Objects.equals(dataItems(), other.dataItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAttackStatisticsResponse").add("TimeRange", timeRange())
                .add("DataItems", hasDataItems() ? dataItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "DataItems":
            return Optional.ofNullable(clazz.cast(dataItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeRange", TIME_RANGE_FIELD);
        map.put("DataItems", DATA_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAttackStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeAttackStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ShieldResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAttackStatisticsResponse> {
        /**
         * <p>
         * The time range of the attack.
         * </p>
         * 
         * @param timeRange
         *        The time range of the attack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(TimeRange timeRange);

        /**
         * <p>
         * The time range of the attack.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #timeRange(TimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(TimeRange)
         */
        default Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return timeRange(TimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * 
         * @param dataItems
         *        The data that describes the attacks detected during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(Collection<AttackStatisticsDataItem> dataItems);

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * 
         * @param dataItems
         *        The data that describes the attacks detected during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataItems(AttackStatisticsDataItem... dataItems);

        /**
         * <p>
         * The data that describes the attacks detected during the time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.AttackStatisticsDataItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.shield.model.AttackStatisticsDataItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.shield.model.AttackStatisticsDataItem.Builder#build()} is called
         * immediately and its result is passed to {@link #dataItems(List<AttackStatisticsDataItem>)}.
         * 
         * @param dataItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.shield.model.AttackStatisticsDataItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataItems(java.util.Collection<AttackStatisticsDataItem>)
         */
        Builder dataItems(Consumer<AttackStatisticsDataItem.Builder>... dataItems);
    }

    static final class BuilderImpl extends ShieldResponse.BuilderImpl implements Builder {
        private TimeRange timeRange;

        private List<AttackStatisticsDataItem> dataItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAttackStatisticsResponse model) {
            super(model);
            timeRange(model.timeRange);
            dataItems(model.dataItems);
        }

        public final TimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final List<AttackStatisticsDataItem.Builder> getDataItems() {
            List<AttackStatisticsDataItem.Builder> result = AttackStatisticsDataListCopier.copyToBuilder(this.dataItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataItems(Collection<AttackStatisticsDataItem.BuilderImpl> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copyFromBuilder(dataItems);
        }

        @Override
        public final Builder dataItems(Collection<AttackStatisticsDataItem> dataItems) {
            this.dataItems = AttackStatisticsDataListCopier.copy(dataItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(AttackStatisticsDataItem... dataItems) {
            dataItems(Arrays.asList(dataItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataItems(Consumer<AttackStatisticsDataItem.Builder>... dataItems) {
            dataItems(Stream.of(dataItems).map(c -> AttackStatisticsDataItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAttackStatisticsResponse build() {
            return new DescribeAttackStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
