/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.shield.DefaultShieldAsyncClient;
import software.amazon.awssdk.services.shield.DefaultShieldBaseClientBuilder;
import software.amazon.awssdk.services.shield.ShieldAsyncClient;
import software.amazon.awssdk.services.shield.ShieldAsyncClientBuilder;
import software.amazon.awssdk.services.shield.ShieldServiceClientConfiguration;
import software.amazon.awssdk.services.shield.endpoints.ShieldEndpointProvider;

@SdkInternalApi
final class DefaultShieldAsyncClientBuilder
extends DefaultShieldBaseClientBuilder<ShieldAsyncClientBuilder, ShieldAsyncClient>
implements ShieldAsyncClientBuilder {
    DefaultShieldAsyncClientBuilder() {
    }

    @Override
    public DefaultShieldAsyncClientBuilder endpointProvider(ShieldEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ShieldAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultShieldAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ShieldServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultShieldAsyncClient client = new DefaultShieldAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ShieldServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ShieldServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

