/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackLayer;
import software.amazon.awssdk.services.shield.model.AttackPropertyIdentifier;
import software.amazon.awssdk.services.shield.model.Contributor;
import software.amazon.awssdk.services.shield.model.TopContributorsCopier;
import software.amazon.awssdk.services.shield.model.Unit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttackProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttackProperty> {
    private static final SdkField<String> ATTACK_LAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttackLayer").getter(AttackProperty.getter(AttackProperty::attackLayerAsString)).setter(AttackProperty.setter(Builder::attackLayer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackLayer").build()}).build();
    private static final SdkField<String> ATTACK_PROPERTY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttackPropertyIdentifier").getter(AttackProperty.getter(AttackProperty::attackPropertyIdentifierAsString)).setter(AttackProperty.setter(Builder::attackPropertyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttackPropertyIdentifier").build()}).build();
    private static final SdkField<List<Contributor>> TOP_CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopContributors").getter(AttackProperty.getter(AttackProperty::topContributors)).setter(AttackProperty.setter(Builder::topContributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopContributors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contributor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(AttackProperty.getter(AttackProperty::unitAsString)).setter(AttackProperty.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Long> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Total").getter(AttackProperty.getter(AttackProperty::total)).setter(AttackProperty.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACK_LAYER_FIELD, ATTACK_PROPERTY_IDENTIFIER_FIELD, TOP_CONTRIBUTORS_FIELD, UNIT_FIELD, TOTAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attackLayer;
    private final String attackPropertyIdentifier;
    private final List<Contributor> topContributors;
    private final String unit;
    private final Long total;

    private AttackProperty(BuilderImpl builder) {
        this.attackLayer = builder.attackLayer;
        this.attackPropertyIdentifier = builder.attackPropertyIdentifier;
        this.topContributors = builder.topContributors;
        this.unit = builder.unit;
        this.total = builder.total;
    }

    public final AttackLayer attackLayer() {
        return AttackLayer.fromValue(this.attackLayer);
    }

    public final String attackLayerAsString() {
        return this.attackLayer;
    }

    public final AttackPropertyIdentifier attackPropertyIdentifier() {
        return AttackPropertyIdentifier.fromValue(this.attackPropertyIdentifier);
    }

    public final String attackPropertyIdentifierAsString() {
        return this.attackPropertyIdentifier;
    }

    public final boolean hasTopContributors() {
        return this.topContributors != null && !(this.topContributors instanceof SdkAutoConstructList);
    }

    public final List<Contributor> topContributors() {
        return this.topContributors;
    }

    public final Unit unit() {
        return Unit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Long total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackLayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attackPropertyIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopContributors() ? this.topContributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackProperty)) {
            return false;
        }
        AttackProperty other = (AttackProperty)obj;
        return Objects.equals(this.attackLayerAsString(), other.attackLayerAsString()) && Objects.equals(this.attackPropertyIdentifierAsString(), other.attackPropertyIdentifierAsString()) && this.hasTopContributors() == other.hasTopContributors() && Objects.equals(this.topContributors(), other.topContributors()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"AttackProperty").add("AttackLayer", (Object)this.attackLayerAsString()).add("AttackPropertyIdentifier", (Object)this.attackPropertyIdentifierAsString()).add("TopContributors", this.hasTopContributors() ? this.topContributors() : null).add("Unit", (Object)this.unitAsString()).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackLayer": {
                return Optional.ofNullable(clazz.cast(this.attackLayerAsString()));
            }
            case "AttackPropertyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.attackPropertyIdentifierAsString()));
            }
            case "TopContributors": {
                return Optional.ofNullable(clazz.cast(this.topContributors()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttackProperty, T> g) {
        return obj -> g.apply((AttackProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackLayer;
        private String attackPropertyIdentifier;
        private List<Contributor> topContributors = DefaultSdkAutoConstructList.getInstance();
        private String unit;
        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackProperty model) {
            this.attackLayer(model.attackLayer);
            this.attackPropertyIdentifier(model.attackPropertyIdentifier);
            this.topContributors(model.topContributors);
            this.unit(model.unit);
            this.total(model.total);
        }

        public final String getAttackLayer() {
            return this.attackLayer;
        }

        public final void setAttackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
        }

        @Override
        @Transient
        public final Builder attackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
            return this;
        }

        @Override
        @Transient
        public final Builder attackLayer(AttackLayer attackLayer) {
            this.attackLayer(attackLayer == null ? null : attackLayer.toString());
            return this;
        }

        public final String getAttackPropertyIdentifier() {
            return this.attackPropertyIdentifier;
        }

        public final void setAttackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
        }

        @Override
        @Transient
        public final Builder attackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
            return this;
        }

        @Override
        @Transient
        public final Builder attackPropertyIdentifier(AttackPropertyIdentifier attackPropertyIdentifier) {
            this.attackPropertyIdentifier(attackPropertyIdentifier == null ? null : attackPropertyIdentifier.toString());
            return this;
        }

        public final List<Contributor.Builder> getTopContributors() {
            List<Contributor.Builder> result = TopContributorsCopier.copyToBuilder(this.topContributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopContributors(Collection<Contributor.BuilderImpl> topContributors) {
            this.topContributors = TopContributorsCopier.copyFromBuilder(topContributors);
        }

        @Override
        @Transient
        public final Builder topContributors(Collection<Contributor> topContributors) {
            this.topContributors = TopContributorsCopier.copy(topContributors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topContributors(Contributor ... topContributors) {
            this.topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topContributors(Consumer<Contributor.Builder> ... topContributors) {
            this.topContributors(Stream.of(topContributors).map(c -> (Contributor)((Contributor.Builder)Contributor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Long getTotal() {
            return this.total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        @Transient
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        public AttackProperty build() {
            return new AttackProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttackProperty> {
        public Builder attackLayer(String var1);

        public Builder attackLayer(AttackLayer var1);

        public Builder attackPropertyIdentifier(String var1);

        public Builder attackPropertyIdentifier(AttackPropertyIdentifier var1);

        public Builder topContributors(Collection<Contributor> var1);

        public Builder topContributors(Contributor ... var1);

        public Builder topContributors(Consumer<Contributor.Builder> ... var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);

        public Builder total(Long var1);
    }
}

