/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.Mitigation;
import software.amazon.awssdk.services.shield.model.MitigationListCopier;
import software.amazon.awssdk.services.shield.model.SubResourceSummary;
import software.amazon.awssdk.services.shield.model.SubResourceSummaryListCopier;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.AttackDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttackDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackDetail> {
    private final String attackId;
    private final String resourceArn;
    private final List<SubResourceSummary> subResources;
    private final Instant startTime;
    private final Instant endTime;
    private final List<SummarizedCounter> attackCounters;
    private final List<Mitigation> mitigations;

    private AttackDetail(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.subResources = builder.subResources;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackCounters = builder.attackCounters;
        this.mitigations = builder.mitigations;
    }

    public String attackId() {
        return this.attackId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<SubResourceSummary> subResources() {
        return this.subResources;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<SummarizedCounter> attackCounters() {
        return this.attackCounters;
    }

    public List<Mitigation> mitigations() {
        return this.mitigations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.attackCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.mitigations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackDetail)) {
            return false;
        }
        AttackDetail other = (AttackDetail)obj;
        return Objects.equals(this.attackId(), other.attackId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.subResources(), other.subResources()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.attackCounters(), other.attackCounters()) && Objects.equals(this.mitigations(), other.mitigations());
    }

    public String toString() {
        return ToString.builder((String)"AttackDetail").add("AttackId", (Object)this.attackId()).add("ResourceArn", (Object)this.resourceArn()).add("SubResources", this.subResources()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AttackCounters", this.attackCounters()).add("Mitigations", this.mitigations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackId": {
                return Optional.of(clazz.cast(this.attackId()));
            }
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "SubResources": {
                return Optional.of(clazz.cast(this.subResources()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "AttackCounters": {
                return Optional.of(clazz.cast(this.attackCounters()));
            }
            case "Mitigations": {
                return Optional.of(clazz.cast(this.mitigations()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private List<SubResourceSummary> subResources;
        private Instant startTime;
        private Instant endTime;
        private List<SummarizedCounter> attackCounters;
        private List<Mitigation> mitigations;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackDetail model) {
            this.attackId(model.attackId);
            this.resourceArn(model.resourceArn);
            this.subResources(model.subResources);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.attackCounters(model.attackCounters);
            this.mitigations(model.mitigations);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<SubResourceSummary.Builder> getSubResources() {
            return this.subResources != null ? (Collection)this.subResources.stream().map(SubResourceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subResources(Collection<SubResourceSummary> subResources) {
            this.subResources = SubResourceSummaryListCopier.copy(subResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subResources(SubResourceSummary ... subResources) {
            this.subResources(Arrays.asList(subResources));
            return this;
        }

        public final void setSubResources(Collection<SubResourceSummary.BuilderImpl> subResources) {
            this.subResources = SubResourceSummaryListCopier.copyFromBuilder(subResources);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<SummarizedCounter.Builder> getAttackCounters() {
            return this.attackCounters != null ? (Collection)this.attackCounters.stream().map(SummarizedCounter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attackCounters(Collection<SummarizedCounter> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copy(attackCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackCounters(SummarizedCounter ... attackCounters) {
            this.attackCounters(Arrays.asList(attackCounters));
            return this;
        }

        public final void setAttackCounters(Collection<SummarizedCounter.BuilderImpl> attackCounters) {
            this.attackCounters = SummarizedCounterListCopier.copyFromBuilder(attackCounters);
        }

        public final Collection<Mitigation.Builder> getMitigations() {
            return this.mitigations != null ? (Collection)this.mitigations.stream().map(Mitigation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mitigations(Collection<Mitigation> mitigations) {
            this.mitigations = MitigationListCopier.copy(mitigations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mitigations(Mitigation ... mitigations) {
            this.mitigations(Arrays.asList(mitigations));
            return this;
        }

        public final void setMitigations(Collection<Mitigation.BuilderImpl> mitigations) {
            this.mitigations = MitigationListCopier.copyFromBuilder(mitigations);
        }

        public AttackDetail build() {
            return new AttackDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackDetail> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder subResources(Collection<SubResourceSummary> var1);

        public Builder subResources(SubResourceSummary ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder attackCounters(Collection<SummarizedCounter> var1);

        public Builder attackCounters(SummarizedCounter ... var1);

        public Builder mitigations(Collection<Mitigation> var1);

        public Builder mitigations(Mitigation ... var1);
    }
}

