/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.shield.DefaultShieldClientBuilder;
import software.amazon.awssdk.services.shield.ShieldClientBuilder;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DeleteSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DeleteSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.InternalErrorException;
import software.amazon.awssdk.services.shield.model.InvalidOperationException;
import software.amazon.awssdk.services.shield.model.InvalidParameterException;
import software.amazon.awssdk.services.shield.model.InvalidResourceException;
import software.amazon.awssdk.services.shield.model.LimitsExceededException;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.LockedSubscriptionException;
import software.amazon.awssdk.services.shield.model.OptimisticLockException;
import software.amazon.awssdk.services.shield.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.shield.model.ResourceNotFoundException;
import software.amazon.awssdk.services.shield.model.ShieldException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface ShieldClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "shield";

    public static ShieldClient create() {
        return (ShieldClient)ShieldClient.builder().build();
    }

    public static ShieldClientBuilder builder() {
        return new DefaultShieldClientBuilder();
    }

    default public CreateProtectionResponse createProtection(CreateProtectionRequest createProtectionRequest) throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException, ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public CreateProtectionResponse createProtection(Consumer<CreateProtectionRequest.Builder> createProtectionRequest) throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException, ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.createProtection((CreateProtectionRequest)((Object)((CreateProtectionRequest.Builder)CreateProtectionRequest.builder().apply(createProtectionRequest)).build()));
    }

    default public CreateSubscriptionResponse createSubscription() throws InternalErrorException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, ShieldException {
        return this.createSubscription((CreateSubscriptionRequest)((Object)CreateSubscriptionRequest.builder().build()));
    }

    default public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest createSubscriptionRequest) throws InternalErrorException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public CreateSubscriptionResponse createSubscription(Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest) throws InternalErrorException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, ShieldException {
        return this.createSubscription((CreateSubscriptionRequest)((Object)((CreateSubscriptionRequest.Builder)CreateSubscriptionRequest.builder().apply(createSubscriptionRequest)).build()));
    }

    default public DeleteProtectionResponse deleteProtection(DeleteProtectionRequest deleteProtectionRequest) throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProtectionResponse deleteProtection(Consumer<DeleteProtectionRequest.Builder> deleteProtectionRequest) throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, SdkBaseException, SdkClientException, ShieldException {
        return this.deleteProtection((DeleteProtectionRequest)((Object)((DeleteProtectionRequest.Builder)DeleteProtectionRequest.builder().apply(deleteProtectionRequest)).build()));
    }

    default public DeleteSubscriptionResponse deleteSubscription() throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.deleteSubscription((DeleteSubscriptionRequest)((Object)DeleteSubscriptionRequest.builder().build()));
    }

    default public DeleteSubscriptionResponse deleteSubscription(DeleteSubscriptionRequest deleteSubscriptionRequest) throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSubscriptionResponse deleteSubscription(Consumer<DeleteSubscriptionRequest.Builder> deleteSubscriptionRequest) throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.deleteSubscription((DeleteSubscriptionRequest)((Object)((DeleteSubscriptionRequest.Builder)DeleteSubscriptionRequest.builder().apply(deleteSubscriptionRequest)).build()));
    }

    default public DescribeAttackResponse describeAttack(DescribeAttackRequest describeAttackRequest) throws InternalErrorException, InvalidParameterException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAttackResponse describeAttack(Consumer<DescribeAttackRequest.Builder> describeAttackRequest) throws InternalErrorException, InvalidParameterException, SdkBaseException, SdkClientException, ShieldException {
        return this.describeAttack((DescribeAttackRequest)((Object)((DescribeAttackRequest.Builder)DescribeAttackRequest.builder().apply(describeAttackRequest)).build()));
    }

    default public DescribeProtectionResponse describeProtection(DescribeProtectionRequest describeProtectionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeProtectionResponse describeProtection(Consumer<DescribeProtectionRequest.Builder> describeProtectionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.describeProtection((DescribeProtectionRequest)((Object)((DescribeProtectionRequest.Builder)DescribeProtectionRequest.builder().apply(describeProtectionRequest)).build()));
    }

    default public DescribeSubscriptionResponse describeSubscription() throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.describeSubscription((DescribeSubscriptionRequest)((Object)DescribeSubscriptionRequest.builder().build()));
    }

    default public DescribeSubscriptionResponse describeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public DescribeSubscriptionResponse describeSubscription(Consumer<DescribeSubscriptionRequest.Builder> describeSubscriptionRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.describeSubscription((DescribeSubscriptionRequest)((Object)((DescribeSubscriptionRequest.Builder)DescribeSubscriptionRequest.builder().apply(describeSubscriptionRequest)).build()));
    }

    default public ListAttacksResponse listAttacks() throws InternalErrorException, InvalidParameterException, InvalidOperationException, SdkBaseException, SdkClientException, ShieldException {
        return this.listAttacks((ListAttacksRequest)((Object)ListAttacksRequest.builder().build()));
    }

    default public ListAttacksResponse listAttacks(ListAttacksRequest listAttacksRequest) throws InternalErrorException, InvalidParameterException, InvalidOperationException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListAttacksResponse listAttacks(Consumer<ListAttacksRequest.Builder> listAttacksRequest) throws InternalErrorException, InvalidParameterException, InvalidOperationException, SdkBaseException, SdkClientException, ShieldException {
        return this.listAttacks((ListAttacksRequest)((Object)((ListAttacksRequest.Builder)ListAttacksRequest.builder().apply(listAttacksRequest)).build()));
    }

    default public ListProtectionsResponse listProtections() throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.listProtections((ListProtectionsRequest)((Object)ListProtectionsRequest.builder().build()));
    }

    default public ListProtectionsResponse listProtections(ListProtectionsRequest listProtectionsRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    default public ListProtectionsResponse listProtections(Consumer<ListProtectionsRequest.Builder> listProtectionsRequest) throws InternalErrorException, ResourceNotFoundException, SdkBaseException, SdkClientException, ShieldException {
        return this.listProtections((ListProtectionsRequest)((Object)((ListProtectionsRequest.Builder)ListProtectionsRequest.builder().apply(listProtectionsRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

