/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.SummarizedAttackVectorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SummarizedAttackVector
implements StructuredPojo,
ToCopyableBuilder<Builder, SummarizedAttackVector> {
    private final String vectorType;
    private final List<SummarizedCounter> vectorCounters;

    private SummarizedAttackVector(BuilderImpl builder) {
        this.vectorType = builder.vectorType;
        this.vectorCounters = builder.vectorCounters;
    }

    public String vectorType() {
        return this.vectorType;
    }

    public List<SummarizedCounter> vectorCounters() {
        return this.vectorCounters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vectorType() == null ? 0 : this.vectorType().hashCode());
        hashCode = 31 * hashCode + (this.vectorCounters() == null ? 0 : this.vectorCounters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedAttackVector)) {
            return false;
        }
        SummarizedAttackVector other = (SummarizedAttackVector)obj;
        if (other.vectorType() == null ^ this.vectorType() == null) {
            return false;
        }
        if (other.vectorType() != null && !other.vectorType().equals(this.vectorType())) {
            return false;
        }
        if (other.vectorCounters() == null ^ this.vectorCounters() == null) {
            return false;
        }
        return other.vectorCounters() == null || other.vectorCounters().equals(this.vectorCounters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vectorType() != null) {
            sb.append("VectorType: ").append(this.vectorType()).append(",");
        }
        if (this.vectorCounters() != null) {
            sb.append("VectorCounters: ").append(this.vectorCounters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VectorType": {
                return Optional.of(clazz.cast(this.vectorType()));
            }
            case "VectorCounters": {
                return Optional.of(clazz.cast(this.vectorCounters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedAttackVectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String vectorType;
        private List<SummarizedCounter> vectorCounters;

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedAttackVector model) {
            this.vectorType(model.vectorType);
            this.vectorCounters(model.vectorCounters);
        }

        public final String getVectorType() {
            return this.vectorType;
        }

        @Override
        public final Builder vectorType(String vectorType) {
            this.vectorType = vectorType;
            return this;
        }

        public final void setVectorType(String vectorType) {
            this.vectorType = vectorType;
        }

        public final Collection<SummarizedCounter.Builder> getVectorCounters() {
            return this.vectorCounters != null ? (Collection)this.vectorCounters.stream().map(SummarizedCounter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vectorCounters(Collection<SummarizedCounter> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copy(vectorCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorCounters(SummarizedCounter ... vectorCounters) {
            this.vectorCounters(Arrays.asList(vectorCounters));
            return this;
        }

        public final void setVectorCounters(Collection<SummarizedCounter.BuilderImpl> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copyFromBuilder(vectorCounters);
        }

        public SummarizedAttackVector build() {
            return new SummarizedAttackVector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SummarizedAttackVector> {
        public Builder vectorType(String var1);

        public Builder vectorCounters(Collection<SummarizedCounter> var1);

        public Builder vectorCounters(SummarizedCounter ... var1);
    }
}

