/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.AttackLayer;
import software.amazon.awssdk.services.shield.model.AttackPropertyIdentifier;
import software.amazon.awssdk.services.shield.model.Contributor;
import software.amazon.awssdk.services.shield.model.TopContributorsCopier;
import software.amazon.awssdk.services.shield.model.Unit;
import software.amazon.awssdk.services.shield.transform.AttackPropertyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttackProperty
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackProperty> {
    private final String attackLayer;
    private final String attackPropertyIdentifier;
    private final List<Contributor> topContributors;
    private final String unit;
    private final Long total;

    private AttackProperty(BuilderImpl builder) {
        this.attackLayer = builder.attackLayer;
        this.attackPropertyIdentifier = builder.attackPropertyIdentifier;
        this.topContributors = builder.topContributors;
        this.unit = builder.unit;
        this.total = builder.total;
    }

    public AttackLayer attackLayer() {
        return AttackLayer.fromValue(this.attackLayer);
    }

    public String attackLayerAsString() {
        return this.attackLayer;
    }

    public AttackPropertyIdentifier attackPropertyIdentifier() {
        return AttackPropertyIdentifier.fromValue(this.attackPropertyIdentifier);
    }

    public String attackPropertyIdentifierAsString() {
        return this.attackPropertyIdentifier;
    }

    public List<Contributor> topContributors() {
        return this.topContributors;
    }

    public Unit unit() {
        return Unit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Long total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attackLayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attackPropertyIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topContributors());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackProperty)) {
            return false;
        }
        AttackProperty other = (AttackProperty)obj;
        return Objects.equals(this.attackLayerAsString(), other.attackLayerAsString()) && Objects.equals(this.attackPropertyIdentifierAsString(), other.attackPropertyIdentifierAsString()) && Objects.equals(this.topContributors(), other.topContributors()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.total(), other.total());
    }

    public String toString() {
        return ToString.builder((String)"AttackProperty").add("AttackLayer", (Object)this.attackLayerAsString()).add("AttackPropertyIdentifier", (Object)this.attackPropertyIdentifierAsString()).add("TopContributors", this.topContributors()).add("Unit", (Object)this.unitAsString()).add("Total", (Object)this.total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttackLayer": {
                return Optional.ofNullable(clazz.cast(this.attackLayerAsString()));
            }
            case "AttackPropertyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.attackPropertyIdentifierAsString()));
            }
            case "TopContributors": {
                return Optional.ofNullable(clazz.cast(this.topContributors()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attackLayer;
        private String attackPropertyIdentifier;
        private List<Contributor> topContributors = DefaultSdkAutoConstructList.getInstance();
        private String unit;
        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackProperty model) {
            this.attackLayer(model.attackLayer);
            this.attackPropertyIdentifier(model.attackPropertyIdentifier);
            this.topContributors(model.topContributors);
            this.unit(model.unit);
            this.total(model.total);
        }

        public final String getAttackLayer() {
            return this.attackLayer;
        }

        @Override
        public final Builder attackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
            return this;
        }

        @Override
        public final Builder attackLayer(AttackLayer attackLayer) {
            this.attackLayer(attackLayer.toString());
            return this;
        }

        public final void setAttackLayer(String attackLayer) {
            this.attackLayer = attackLayer;
        }

        public final String getAttackPropertyIdentifier() {
            return this.attackPropertyIdentifier;
        }

        @Override
        public final Builder attackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
            return this;
        }

        @Override
        public final Builder attackPropertyIdentifier(AttackPropertyIdentifier attackPropertyIdentifier) {
            this.attackPropertyIdentifier(attackPropertyIdentifier.toString());
            return this;
        }

        public final void setAttackPropertyIdentifier(String attackPropertyIdentifier) {
            this.attackPropertyIdentifier = attackPropertyIdentifier;
        }

        public final Collection<Contributor.Builder> getTopContributors() {
            return this.topContributors != null ? (Collection)this.topContributors.stream().map(Contributor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topContributors(Collection<Contributor> topContributors) {
            this.topContributors = TopContributorsCopier.copy(topContributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Contributor ... topContributors) {
            this.topContributors(Arrays.asList(topContributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topContributors(Consumer<Contributor.Builder> ... topContributors) {
            this.topContributors(Stream.of(topContributors).map(c -> (Contributor)((Contributor.Builder)Contributor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopContributors(Collection<Contributor.BuilderImpl> topContributors) {
            this.topContributors = TopContributorsCopier.copyFromBuilder(topContributors);
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Long getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        public AttackProperty build() {
            return new AttackProperty(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackProperty> {
        public Builder attackLayer(String var1);

        public Builder attackLayer(AttackLayer var1);

        public Builder attackPropertyIdentifier(String var1);

        public Builder attackPropertyIdentifier(AttackPropertyIdentifier var1);

        public Builder topContributors(Collection<Contributor> var1);

        public Builder topContributors(Contributor ... var1);

        public Builder topContributors(Consumer<Contributor.Builder> ... var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);

        public Builder total(Long var1);
    }
}

