/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.SummarizedAttackVector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SummarizedAttackVectorMarshaller {
    private static final MarshallingInfo<String> VECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VectorType").isBinary(false).build();
    private static final MarshallingInfo<List> VECTORCOUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VectorCounters").isBinary(false).build();
    private static final SummarizedAttackVectorMarshaller INSTANCE = new SummarizedAttackVectorMarshaller();

    private SummarizedAttackVectorMarshaller() {
    }

    public static SummarizedAttackVectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SummarizedAttackVector summarizedAttackVector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)summarizedAttackVector, (String)"summarizedAttackVector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)summarizedAttackVector.vectorType(), VECTORTYPE_BINDING);
            protocolMarshaller.marshall(summarizedAttackVector.vectorCounters(), VECTORCOUNTERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

