/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.shield.model.AttackSummariesCopier;
import software.amazon.awssdk.services.shield.model.AttackSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAttacksResponse> {
    private final List<AttackSummary> attackSummaries;
    private final String nextToken;

    private ListAttacksResponse(BuilderImpl builder) {
        this.attackSummaries = builder.attackSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<AttackSummary> attackSummaries() {
        return this.attackSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attackSummaries() == null ? 0 : this.attackSummaries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttacksResponse)) {
            return false;
        }
        ListAttacksResponse other = (ListAttacksResponse)((Object)obj);
        if (other.attackSummaries() == null ^ this.attackSummaries() == null) {
            return false;
        }
        if (other.attackSummaries() != null && !other.attackSummaries().equals(this.attackSummaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attackSummaries() != null) {
            sb.append("AttackSummaries: ").append(this.attackSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttackSummary> attackSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttacksResponse model) {
            this.setAttackSummaries(model.attackSummaries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AttackSummary> getAttackSummaries() {
            return this.attackSummaries;
        }

        @Override
        public final Builder attackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackSummaries(AttackSummary ... attackSummaries) {
            if (this.attackSummaries == null) {
                this.attackSummaries = new ArrayList<AttackSummary>(attackSummaries.length);
            }
            for (AttackSummary e : attackSummaries) {
                this.attackSummaries.add(e);
            }
            return this;
        }

        public final void setAttackSummaries(Collection<AttackSummary> attackSummaries) {
            this.attackSummaries = AttackSummariesCopier.copy(attackSummaries);
        }

        @SafeVarargs
        public final void setAttackSummaries(AttackSummary ... attackSummaries) {
            if (this.attackSummaries == null) {
                this.attackSummaries = new ArrayList<AttackSummary>(attackSummaries.length);
            }
            for (AttackSummary e : attackSummaries) {
                this.attackSummaries.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAttacksResponse build() {
            return new ListAttacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAttacksResponse> {
        public Builder attackSummaries(Collection<AttackSummary> var1);

        public Builder attackSummaries(AttackSummary ... var1);

        public Builder nextToken(String var1);
    }
}

