/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.ActivityDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ActivityLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ActivityWorkerLimitExceededException;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ExecutionAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ExecutionDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ExecutionLimitExceededException;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.InvalidArnException;
import software.amazon.awssdk.services.sfn.model.InvalidDefinitionException;
import software.amazon.awssdk.services.sfn.model.InvalidExecutionInputException;
import software.amazon.awssdk.services.sfn.model.InvalidNameException;
import software.amazon.awssdk.services.sfn.model.InvalidOutputException;
import software.amazon.awssdk.services.sfn.model.InvalidTokenException;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sfn.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sfn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessResponse;
import software.amazon.awssdk.services.sfn.model.SfnException;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.StateMachineDeletingException;
import software.amazon.awssdk.services.sfn.model.StateMachineDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.StateMachineLimitExceededException;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.TagResourceRequest;
import software.amazon.awssdk.services.sfn.model.TagResourceResponse;
import software.amazon.awssdk.services.sfn.model.TaskDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.TaskTimedOutException;
import software.amazon.awssdk.services.sfn.model.TooManyTagsException;
import software.amazon.awssdk.services.sfn.model.UntagResourceRequest;
import software.amazon.awssdk.services.sfn.model.UntagResourceResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;
import software.amazon.awssdk.services.sfn.paginators.GetExecutionHistoryIterable;
import software.amazon.awssdk.services.sfn.paginators.ListActivitiesIterable;
import software.amazon.awssdk.services.sfn.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.sfn.paginators.ListStateMachinesIterable;
import software.amazon.awssdk.services.sfn.transform.CreateActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.CreateStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListActivitiesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachinesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskFailureRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskSuccessRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StartExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StopExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateStateMachineRequestMarshaller;

@SdkInternalApi
final class DefaultSfnClient
implements SfnClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSfnClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "states";
    }

    @Override
    public CreateActivityResponse createActivity(CreateActivityRequest createActivityRequest) throws ActivityLimitExceededException, InvalidNameException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateActivityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateActivity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createActivityRequest).withMarshaller((Marshaller)new CreateActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateStateMachineResponse createStateMachine(CreateStateMachineRequest createStateMachineRequest) throws InvalidArnException, InvalidDefinitionException, InvalidNameException, StateMachineAlreadyExistsException, StateMachineDeletingException, StateMachineLimitExceededException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStateMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStateMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStateMachineRequest).withMarshaller((Marshaller)new CreateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteActivityResponse deleteActivity(DeleteActivityRequest deleteActivityRequest) throws InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteActivityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteActivity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteActivityRequest).withMarshaller((Marshaller)new DeleteActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteStateMachineResponse deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest) throws InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStateMachineRequest).withMarshaller((Marshaller)new DeleteStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeActivityResponse describeActivity(DescribeActivityRequest describeActivityRequest) throws ActivityDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeActivityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActivityRequest).withMarshaller((Marshaller)new DescribeActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExecutionRequest).withMarshaller((Marshaller)new DescribeExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeStateMachineResponse describeStateMachine(DescribeStateMachineRequest describeStateMachineRequest) throws InvalidArnException, StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStateMachineRequest).withMarshaller((Marshaller)new DescribeStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeStateMachineForExecutionResponse describeStateMachineForExecution(DescribeStateMachineForExecutionRequest describeStateMachineForExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineForExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeStateMachineForExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachineForExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStateMachineForExecutionRequest).withMarshaller((Marshaller)new DescribeStateMachineForExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetActivityTaskResponse getActivityTask(GetActivityTaskRequest getActivityTaskRequest) throws ActivityDoesNotExistException, ActivityWorkerLimitExceededException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActivityTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetActivityTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActivityTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getActivityTaskRequest).withMarshaller((Marshaller)new GetActivityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetExecutionHistoryResponse getExecutionHistory(GetExecutionHistoryRequest getExecutionHistoryRequest) throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExecutionHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetExecutionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExecutionHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getExecutionHistoryRequest).withMarshaller((Marshaller)new GetExecutionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetExecutionHistoryIterable getExecutionHistoryPaginator(GetExecutionHistoryRequest getExecutionHistoryRequest) throws ExecutionDoesNotExistException, InvalidArnException, InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return new GetExecutionHistoryIterable(this, this.applyPaginatorUserAgent(getExecutionHistoryRequest));
    }

    @Override
    public ListActivitiesResponse listActivities(ListActivitiesRequest listActivitiesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listActivitiesRequest).withMarshaller((Marshaller)new ListActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListActivitiesIterable listActivitiesPaginator(ListActivitiesRequest listActivitiesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return new ListActivitiesIterable(this, this.applyPaginatorUserAgent(listActivitiesRequest));
    }

    @Override
    public ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExecutionsRequest).withMarshaller((Marshaller)new ListExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) throws InvalidArnException, InvalidTokenException, StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        return new ListExecutionsIterable(this, this.applyPaginatorUserAgent(listExecutionsRequest));
    }

    @Override
    public ListStateMachinesResponse listStateMachines(ListStateMachinesRequest listStateMachinesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListStateMachinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStateMachinesRequest).withMarshaller((Marshaller)new ListStateMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListStateMachinesIterable listStateMachinesPaginator(ListStateMachinesRequest listStateMachinesRequest) throws InvalidTokenException, AwsServiceException, SdkClientException, SfnException {
        return new ListStateMachinesIterable(this, this.applyPaginatorUserAgent(listStateMachinesRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SendTaskFailureResponse sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest) throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskFailureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SendTaskFailureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskFailure").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTaskFailureRequest).withMarshaller((Marshaller)new SendTaskFailureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SendTaskHeartbeatResponse sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest) throws TaskDoesNotExistException, InvalidTokenException, TaskTimedOutException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskHeartbeatResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SendTaskHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskHeartbeat").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTaskHeartbeatRequest).withMarshaller((Marshaller)new SendTaskHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SendTaskSuccessResponse sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest) throws TaskDoesNotExistException, InvalidOutputException, InvalidTokenException, TaskTimedOutException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskSuccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SendTaskSuccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskSuccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTaskSuccessRequest).withMarshaller((Marshaller)new SendTaskSuccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartExecutionResponse startExecution(StartExecutionRequest startExecutionRequest) throws ExecutionLimitExceededException, ExecutionAlreadyExistsException, InvalidArnException, InvalidExecutionInputException, InvalidNameException, StateMachineDoesNotExistException, StateMachineDeletingException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startExecutionRequest).withMarshaller((Marshaller)new StartExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopExecutionResponse stopExecution(StopExecutionRequest stopExecutionRequest) throws ExecutionDoesNotExistException, InvalidArnException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopExecutionRequest).withMarshaller((Marshaller)new StopExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidArnException, ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidArnException, ResourceNotFoundException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateStateMachineResponse updateStateMachine(UpdateStateMachineRequest updateStateMachineRequest) throws InvalidArnException, InvalidDefinitionException, MissingRequiredParameterException, StateMachineDeletingException, StateMachineDoesNotExistException, AwsServiceException, SdkClientException, SfnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStateMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateStateMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStateMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStateMachineRequest).withMarshaller((Marshaller)new UpdateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SfnException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDefinition").exceptionBuilderSupplier(InvalidDefinitionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidName").exceptionBuilderSupplier(InvalidNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArn").exceptionBuilderSupplier(InvalidArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StateMachineDeleting").exceptionBuilderSupplier(StateMachineDeletingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TaskTimedOut").exceptionBuilderSupplier(TaskTimedOutException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").exceptionBuilderSupplier(MissingRequiredParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidToken").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOutput").exceptionBuilderSupplier(InvalidOutputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").exceptionBuilderSupplier(ActivityLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").exceptionBuilderSupplier(InvalidExecutionInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").exceptionBuilderSupplier(TaskDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SfnRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.9.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SfnRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

