/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestStateRequest extends SfnRequest implements ToCopyableBuilder<TestStateRequest.Builder, TestStateRequest> {
    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(TestStateRequest::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(TestStateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(TestStateRequest::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> INSPECTION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inspectionLevel").getter(getter(TestStateRequest::inspectionLevelAsString))
            .setter(setter(Builder::inspectionLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectionLevel").build()).build();

    private static final SdkField<Boolean> REVEAL_SECRETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("revealSecrets").getter(getter(TestStateRequest::revealSecrets)).setter(setter(Builder::revealSecrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revealSecrets").build()).build();

    private static final SdkField<String> VARIABLES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variables").getter(getter(TestStateRequest::variables)).setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build()).build();

    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(TestStateRequest::stateName)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<MockInput> MOCK_FIELD = SdkField.<MockInput> builder(MarshallingType.SDK_POJO)
            .memberName("mock").getter(getter(TestStateRequest::mock)).setter(setter(Builder::mock))
            .constructor(MockInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mock").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(TestStateRequest::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<TestStateConfiguration> STATE_CONFIGURATION_FIELD = SdkField
            .<TestStateConfiguration> builder(MarshallingType.SDK_POJO).memberName("stateConfiguration")
            .getter(getter(TestStateRequest::stateConfiguration)).setter(setter(Builder::stateConfiguration))
            .constructor(TestStateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            ROLE_ARN_FIELD, INPUT_FIELD, INSPECTION_LEVEL_FIELD, REVEAL_SECRETS_FIELD, VARIABLES_FIELD, STATE_NAME_FIELD,
            MOCK_FIELD, CONTEXT_FIELD, STATE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String definition;

    private final String roleArn;

    private final String input;

    private final String inspectionLevel;

    private final Boolean revealSecrets;

    private final String variables;

    private final String stateName;

    private final MockInput mock;

    private final String context;

    private final TestStateConfiguration stateConfiguration;

    private TestStateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inspectionLevel = builder.inspectionLevel;
        this.revealSecrets = builder.revealSecrets;
        this.variables = builder.variables;
        this.stateName = builder.stateName;
        this.mock = builder.mock;
        this.context = builder.context;
        this.stateConfiguration = builder.stateConfiguration;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     * States Language</a> (ASL) definition of the state or state machine.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a> (ASL) definition of the state or state machine.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A string that contains the JSON input data for the state.
     * </p>
     * 
     * @return A string that contains the JSON input data for the state.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Determines the values to return when a state is tested. You can specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code> to
     * <code>INFO</code> if you don't specify a level.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final state
     * output along with the input and output data processing result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each of these levels also provide information about the status of the state execution and the next state to
     * transition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return Determines the values to return when a state is tested. You can specify one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code>: Shows the final state output. By default, Step Functions sets
     *         <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
     *         state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Each of these levels also provide information about the status of the state execution and the next state
     *         to transition to.
     * @see InspectionLevel
     */
    public final InspectionLevel inspectionLevel() {
        return InspectionLevel.fromValue(inspectionLevel);
    }

    /**
     * <p>
     * Determines the values to return when a state is tested. You can specify one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code> to
     * <code>INFO</code> if you don't specify a level.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final state
     * output along with the input and output data processing result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each of these levels also provide information about the status of the state execution and the next state to
     * transition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inspectionLevel}
     * will return {@link InspectionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inspectionLevelAsString}.
     * </p>
     * 
     * @return Determines the values to return when a state is tested. You can specify one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INFO</code>: Shows the final state output. By default, Step Functions sets
     *         <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
     *         state output along with the input and output data processing result.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Each of these levels also provide information about the status of the state execution and the next state
     *         to transition to.
     * @see InspectionLevel
     */
    public final String inspectionLevelAsString() {
        return inspectionLevel;
    }

    /**
     * <p>
     * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes the
     * data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body. Step
     * Functions doesn't omit any information included in the state definition or the HTTP response.
     * </p>
     * <p>
     * If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that calls the
     * <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For an example of IAM
     * policy that sets the <code>states:RevealSecrets</code> permission, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
     * permissions to test a state</a>. Without this permission, Step Functions throws an access denied error.
     * </p>
     * <p>
     * By default, <code>revealSecrets</code> is set to <code>false</code>.
     * </p>
     * 
     * @return Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret
     *         includes the data that an EventBridge connection adds to modify the HTTP request headers, query
     *         parameters, and body. Step Functions doesn't omit any information included in the state definition or the
     *         HTTP response.</p>
     *         <p>
     *         If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that
     *         calls the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For
     *         an example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions"
     *         >IAM permissions to test a state</a>. Without this permission, Step Functions throws an access denied
     *         error.
     *         </p>
     *         <p>
     *         By default, <code>revealSecrets</code> is set to <code>false</code>.
     */
    public final Boolean revealSecrets() {
        return revealSecrets;
    }

    /**
     * <p>
     * JSON object literal that sets variables used in the state under test. Object keys are the variable names and
     * values are the variable values.
     * </p>
     * 
     * @return JSON object literal that sets variables used in the state under test. Object keys are the variable names
     *         and values are the variable values.
     */
    public final String variables() {
        return variables;
    }

    /**
     * <p>
     * Denotes the particular state within a state machine definition to be tested. If this field is specified, the
     * <code>definition</code> must contain a fully-formed state machine definition.
     * </p>
     * 
     * @return Denotes the particular state within a state machine definition to be tested. If this field is specified,
     *         the <code>definition</code> must contain a fully-formed state machine definition.
     */
    public final String stateName() {
        return stateName;
    }

    /**
     * <p>
     * Defines a mocked result or error for the state under test.
     * </p>
     * <p>
     * A mock can only be specified for Task, Map, or Parallel states. If it is specified for another state type, an
     * exception will be thrown.
     * </p>
     * 
     * @return Defines a mocked result or error for the state under test.</p>
     *         <p>
     *         A mock can only be specified for Task, Map, or Parallel states. If it is specified for another state
     *         type, an exception will be thrown.
     */
    public final MockInput mock() {
        return mock;
    }

    /**
     * <p>
     * A JSON string representing a valid Context object for the state under test. This field may only be specified if a
     * mock is specified in the same request.
     * </p>
     * 
     * @return A JSON string representing a valid Context object for the state under test. This field may only be
     *         specified if a mock is specified in the same request.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * Contains configurations for the state under test.
     * </p>
     * 
     * @return Contains configurations for the state under test.
     */
    public final TestStateConfiguration stateConfiguration() {
        return stateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inspectionLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revealSecrets());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        hashCode = 31 * hashCode + Objects.hashCode(stateName());
        hashCode = 31 * hashCode + Objects.hashCode(mock());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(stateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateRequest)) {
            return false;
        }
        TestStateRequest other = (TestStateRequest) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(input(), other.input())
                && Objects.equals(inspectionLevelAsString(), other.inspectionLevelAsString())
                && Objects.equals(revealSecrets(), other.revealSecrets()) && Objects.equals(variables(), other.variables())
                && Objects.equals(stateName(), other.stateName()) && Objects.equals(mock(), other.mock())
                && Objects.equals(context(), other.context()) && Objects.equals(stateConfiguration(), other.stateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestStateRequest")
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InspectionLevel", inspectionLevelAsString()).add("RevealSecrets", revealSecrets())
                .add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateName", stateName() == null ? null : "*** Sensitive Data Redacted ***").add("Mock", mock())
                .add("Context", context() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateConfiguration", stateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inspectionLevel":
            return Optional.ofNullable(clazz.cast(inspectionLevelAsString()));
        case "revealSecrets":
            return Optional.ofNullable(clazz.cast(revealSecrets()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateName()));
        case "mock":
            return Optional.ofNullable(clazz.cast(mock()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "stateConfiguration":
            return Optional.ofNullable(clazz.cast(stateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("inspectionLevel", INSPECTION_LEVEL_FIELD);
        map.put("revealSecrets", REVEAL_SECRETS_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("stateName", STATE_NAME_FIELD);
        map.put("mock", MOCK_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("stateConfiguration", STATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestStateRequest, T> g) {
        return obj -> g.apply((TestStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestStateRequest> {
        /**
         * <p>
         * The <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a> (ASL) definition of the state or state machine.
         * </p>
         * 
         * @param definition
         *        The <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a> (ASL) definition of the state or state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A string that contains the JSON input data for the state.
         * </p>
         * 
         * @param input
         *        A string that contains the JSON input data for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Determines the values to return when a state is tested. You can specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code>
         * to <code>INFO</code> if you don't specify a level.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
         * state output along with the input and output data processing result.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each of these levels also provide information about the status of the state execution and the next state to
         * transition to.
         * </p>
         * 
         * @param inspectionLevel
         *        Determines the values to return when a state is tested. You can specify one of the following
         *        types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code>: Shows the final state output. By default, Step Functions sets
         *        <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEBUG</code>: Shows the final state output along with the input and output data processing
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the
         *        final state output along with the input and output data processing result.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Each of these levels also provide information about the status of the state execution and the next
         *        state to transition to.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(String inspectionLevel);

        /**
         * <p>
         * Determines the values to return when a state is tested. You can specify one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code>
         * to <code>INFO</code> if you don't specify a level.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final
         * state output along with the input and output data processing result.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each of these levels also provide information about the status of the state execution and the next state to
         * transition to.
         * </p>
         * 
         * @param inspectionLevel
         *        Determines the values to return when a state is tested. You can specify one of the following
         *        types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INFO</code>: Shows the final state output. By default, Step Functions sets
         *        <code>inspectionLevel</code> to <code>INFO</code> if you don't specify a level.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEBUG</code>: Shows the final state output along with the input and output data processing
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the
         *        final state output along with the input and output data processing result.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Each of these levels also provide information about the status of the state execution and the next
         *        state to transition to.
         * @see InspectionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectionLevel
         */
        Builder inspectionLevel(InspectionLevel inspectionLevel);

        /**
         * <p>
         * Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes
         * the data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body.
         * Step Functions doesn't omit any information included in the state definition or the HTTP response.
         * </p>
         * <p>
         * If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that calls
         * the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For an
         * example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM
         * permissions to test a state</a>. Without this permission, Step Functions throws an access denied error.
         * </p>
         * <p>
         * By default, <code>revealSecrets</code> is set to <code>false</code>.
         * </p>
         * 
         * @param revealSecrets
         *        Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret
         *        includes the data that an EventBridge connection adds to modify the HTTP request headers, query
         *        parameters, and body. Step Functions doesn't omit any information included in the state definition or
         *        the HTTP response.</p>
         *        <p>
         *        If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that
         *        calls the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action.
         *        For an example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions"
         *        >IAM permissions to test a state</a>. Without this permission, Step Functions throws an access denied
         *        error.
         *        </p>
         *        <p>
         *        By default, <code>revealSecrets</code> is set to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revealSecrets(Boolean revealSecrets);

        /**
         * <p>
         * JSON object literal that sets variables used in the state under test. Object keys are the variable names and
         * values are the variable values.
         * </p>
         * 
         * @param variables
         *        JSON object literal that sets variables used in the state under test. Object keys are the variable
         *        names and values are the variable values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(String variables);

        /**
         * <p>
         * Denotes the particular state within a state machine definition to be tested. If this field is specified, the
         * <code>definition</code> must contain a fully-formed state machine definition.
         * </p>
         * 
         * @param stateName
         *        Denotes the particular state within a state machine definition to be tested. If this field is
         *        specified, the <code>definition</code> must contain a fully-formed state machine definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * Defines a mocked result or error for the state under test.
         * </p>
         * <p>
         * A mock can only be specified for Task, Map, or Parallel states. If it is specified for another state type, an
         * exception will be thrown.
         * </p>
         * 
         * @param mock
         *        Defines a mocked result or error for the state under test.</p>
         *        <p>
         *        A mock can only be specified for Task, Map, or Parallel states. If it is specified for another state
         *        type, an exception will be thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mock(MockInput mock);

        /**
         * <p>
         * Defines a mocked result or error for the state under test.
         * </p>
         * <p>
         * A mock can only be specified for Task, Map, or Parallel states. If it is specified for another state type, an
         * exception will be thrown.
         * </p>
         * This is a convenience method that creates an instance of the {@link MockInput.Builder} avoiding the need to
         * create one manually via {@link MockInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MockInput.Builder#build()} is called immediately and its result
         * is passed to {@link #mock(MockInput)}.
         * 
         * @param mock
         *        a consumer that will call methods on {@link MockInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mock(MockInput)
         */
        default Builder mock(Consumer<MockInput.Builder> mock) {
            return mock(MockInput.builder().applyMutation(mock).build());
        }

        /**
         * <p>
         * A JSON string representing a valid Context object for the state under test. This field may only be specified
         * if a mock is specified in the same request.
         * </p>
         * 
         * @param context
         *        A JSON string representing a valid Context object for the state under test. This field may only be
         *        specified if a mock is specified in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * Contains configurations for the state under test.
         * </p>
         * 
         * @param stateConfiguration
         *        Contains configurations for the state under test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateConfiguration(TestStateConfiguration stateConfiguration);

        /**
         * <p>
         * Contains configurations for the state under test.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestStateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TestStateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestStateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #stateConfiguration(TestStateConfiguration)}.
         * 
         * @param stateConfiguration
         *        a consumer that will call methods on {@link TestStateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateConfiguration(TestStateConfiguration)
         */
        default Builder stateConfiguration(Consumer<TestStateConfiguration.Builder> stateConfiguration) {
            return stateConfiguration(TestStateConfiguration.builder().applyMutation(stateConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String definition;

        private String roleArn;

        private String input;

        private String inspectionLevel;

        private Boolean revealSecrets;

        private String variables;

        private String stateName;

        private MockInput mock;

        private String context;

        private TestStateConfiguration stateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateRequest model) {
            super(model);
            definition(model.definition);
            roleArn(model.roleArn);
            input(model.input);
            inspectionLevel(model.inspectionLevel);
            revealSecrets(model.revealSecrets);
            variables(model.variables);
            stateName(model.stateName);
            mock(model.mock);
            context(model.context);
            stateConfiguration(model.stateConfiguration);
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getInspectionLevel() {
            return inspectionLevel;
        }

        public final void setInspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
        }

        @Override
        public final Builder inspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
            return this;
        }

        @Override
        public final Builder inspectionLevel(InspectionLevel inspectionLevel) {
            this.inspectionLevel(inspectionLevel == null ? null : inspectionLevel.toString());
            return this;
        }

        public final Boolean getRevealSecrets() {
            return revealSecrets;
        }

        public final void setRevealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
        }

        @Override
        public final Builder revealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
            return this;
        }

        public final String getVariables() {
            return variables;
        }

        public final void setVariables(String variables) {
            this.variables = variables;
        }

        @Override
        public final Builder variables(String variables) {
            this.variables = variables;
            return this;
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final MockInput.Builder getMock() {
            return mock != null ? mock.toBuilder() : null;
        }

        public final void setMock(MockInput.BuilderImpl mock) {
            this.mock = mock != null ? mock.build() : null;
        }

        @Override
        public final Builder mock(MockInput mock) {
            this.mock = mock;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final TestStateConfiguration.Builder getStateConfiguration() {
            return stateConfiguration != null ? stateConfiguration.toBuilder() : null;
        }

        public final void setStateConfiguration(TestStateConfiguration.BuilderImpl stateConfiguration) {
            this.stateConfiguration = stateConfiguration != null ? stateConfiguration.build() : null;
        }

        @Override
        public final Builder stateConfiguration(TestStateConfiguration stateConfiguration) {
            this.stateConfiguration = stateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestStateRequest build() {
            return new TestStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
