/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Step Functions</fullname>
 * <p>
 * With Step Functions, you can create workflows, also called <i>state machines</i>, to build distributed applications,
 * automate processes, orchestrate microservices, and create data and machine learning pipelines.
 * </p>
 * <p>
 * Through the Step Functions API, you can create, list, update, and delete state machines, activities, and other data
 * types. You can start, stop, and redrive your state machines. Your activity workers can send task success, heartbeat,
 * and failure responses.
 * </p>
 * <p>
 * With API calls, you can also manage other aspects of your workflow, such as tags, versions, and aliases.
 * </p>
 * <p>
 * For more information about developing solutions with Step Functions, see the <i> <a
 * href="https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html">Step Functions Developer Guide</a> </i>.
 * </p>
 * <important>
 * <p>
 * If you use the Step Functions API actions using Amazon Web Services SDK integrations, make sure the API actions are
 * in camel case and parameter names are in Pascal case. For example, you might use Step Functions API action
 * <code>startSyncExecution</code> and specify its parameter as <code>StateMachineArn</code>.
 * </p>
 * </important>
 */
package software.amazon.awssdk.services.sfn;