/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing data about a handled exception in the tested state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectionErrorDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InspectionErrorDetails.Builder, InspectionErrorDetails> {
    private static final SdkField<Integer> CATCH_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("catchIndex").getter(getter(InspectionErrorDetails::catchIndex)).setter(setter(Builder::catchIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catchIndex").build()).build();

    private static final SdkField<Integer> RETRY_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retryIndex").getter(getter(InspectionErrorDetails::retryIndex)).setter(setter(Builder::retryIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryIndex").build()).build();

    private static final SdkField<Integer> RETRY_BACKOFF_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("retryBackoffIntervalSeconds")
            .getter(getter(InspectionErrorDetails::retryBackoffIntervalSeconds))
            .setter(setter(Builder::retryBackoffIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryBackoffIntervalSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATCH_INDEX_FIELD,
            RETRY_INDEX_FIELD, RETRY_BACKOFF_INTERVAL_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer catchIndex;

    private final Integer retryIndex;

    private final Integer retryBackoffIntervalSeconds;

    private InspectionErrorDetails(BuilderImpl builder) {
        this.catchIndex = builder.catchIndex;
        this.retryIndex = builder.retryIndex;
        this.retryBackoffIntervalSeconds = builder.retryBackoffIntervalSeconds;
    }

    /**
     * <p>
     * The array index of the Catch which handled the exception.
     * </p>
     * 
     * @return The array index of the Catch which handled the exception.
     */
    public final Integer catchIndex() {
        return catchIndex;
    }

    /**
     * <p>
     * The array index of the Retry which handled the exception.
     * </p>
     * 
     * @return The array index of the Retry which handled the exception.
     */
    public final Integer retryIndex() {
        return retryIndex;
    }

    /**
     * <p>
     * The duration in seconds of the backoff for a retry on a failed state invocation.
     * </p>
     * 
     * @return The duration in seconds of the backoff for a retry on a failed state invocation.
     */
    public final Integer retryBackoffIntervalSeconds() {
        return retryBackoffIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(retryIndex());
        hashCode = 31 * hashCode + Objects.hashCode(retryBackoffIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionErrorDetails)) {
            return false;
        }
        InspectionErrorDetails other = (InspectionErrorDetails) obj;
        return Objects.equals(catchIndex(), other.catchIndex()) && Objects.equals(retryIndex(), other.retryIndex())
                && Objects.equals(retryBackoffIntervalSeconds(), other.retryBackoffIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("InspectionErrorDetails")
                .add("CatchIndex", catchIndex() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RetryIndex", retryIndex() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RetryBackoffIntervalSeconds",
                        retryBackoffIntervalSeconds() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catchIndex":
            return Optional.ofNullable(clazz.cast(catchIndex()));
        case "retryIndex":
            return Optional.ofNullable(clazz.cast(retryIndex()));
        case "retryBackoffIntervalSeconds":
            return Optional.ofNullable(clazz.cast(retryBackoffIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catchIndex", CATCH_INDEX_FIELD);
        map.put("retryIndex", RETRY_INDEX_FIELD);
        map.put("retryBackoffIntervalSeconds", RETRY_BACKOFF_INTERVAL_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InspectionErrorDetails, T> g) {
        return obj -> g.apply((InspectionErrorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectionErrorDetails> {
        /**
         * <p>
         * The array index of the Catch which handled the exception.
         * </p>
         * 
         * @param catchIndex
         *        The array index of the Catch which handled the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catchIndex(Integer catchIndex);

        /**
         * <p>
         * The array index of the Retry which handled the exception.
         * </p>
         * 
         * @param retryIndex
         *        The array index of the Retry which handled the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryIndex(Integer retryIndex);

        /**
         * <p>
         * The duration in seconds of the backoff for a retry on a failed state invocation.
         * </p>
         * 
         * @param retryBackoffIntervalSeconds
         *        The duration in seconds of the backoff for a retry on a failed state invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryBackoffIntervalSeconds(Integer retryBackoffIntervalSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer catchIndex;

        private Integer retryIndex;

        private Integer retryBackoffIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionErrorDetails model) {
            catchIndex(model.catchIndex);
            retryIndex(model.retryIndex);
            retryBackoffIntervalSeconds(model.retryBackoffIntervalSeconds);
        }

        public final Integer getCatchIndex() {
            return catchIndex;
        }

        public final void setCatchIndex(Integer catchIndex) {
            this.catchIndex = catchIndex;
        }

        @Override
        public final Builder catchIndex(Integer catchIndex) {
            this.catchIndex = catchIndex;
            return this;
        }

        public final Integer getRetryIndex() {
            return retryIndex;
        }

        public final void setRetryIndex(Integer retryIndex) {
            this.retryIndex = retryIndex;
        }

        @Override
        public final Builder retryIndex(Integer retryIndex) {
            this.retryIndex = retryIndex;
            return this;
        }

        public final Integer getRetryBackoffIntervalSeconds() {
            return retryBackoffIntervalSeconds;
        }

        public final void setRetryBackoffIntervalSeconds(Integer retryBackoffIntervalSeconds) {
            this.retryBackoffIntervalSeconds = retryBackoffIntervalSeconds;
        }

        @Override
        public final Builder retryBackoffIntervalSeconds(Integer retryBackoffIntervalSeconds) {
            this.retryBackoffIntervalSeconds = retryBackoffIntervalSeconds;
            return this;
        }

        @Override
        public InspectionErrorDetails build() {
            return new InspectionErrorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
