/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateActivityResponse extends SfnResponse implements
        ToCopyableBuilder<CreateActivityResponse.Builder, CreateActivityResponse> {
    private static final SdkField<String> ACTIVITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activityArn").getter(getter(CreateActivityResponse::activityArn)).setter(setter(Builder::activityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(CreateActivityResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ARN_FIELD,
            CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String activityArn;

    private final Instant creationDate;

    private CreateActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the created activity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the created activity.
     */
    public final String activityArn() {
        return activityArn;
    }

    /**
     * <p>
     * The date the activity is created.
     * </p>
     * 
     * @return The date the activity is created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivityResponse)) {
            return false;
        }
        CreateActivityResponse other = (CreateActivityResponse) obj;
        return Objects.equals(activityArn(), other.activityArn()) && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateActivityResponse").add("ActivityArn", activityArn()).add("CreationDate", creationDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activityArn":
            return Optional.ofNullable(clazz.cast(activityArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activityArn", ACTIVITY_ARN_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateActivityResponse, T> g) {
        return obj -> g.apply((CreateActivityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateActivityResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the created activity.
         * </p>
         * 
         * @param activityArn
         *        The Amazon Resource Name (ARN) that identifies the created activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityArn(String activityArn);

        /**
         * <p>
         * The date the activity is created.
         * </p>
         * 
         * @param creationDate
         *        The date the activity is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String activityArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivityResponse model) {
            super(model);
            activityArn(model.activityArn);
            creationDate(model.creationDate);
        }

        public final String getActivityArn() {
            return activityArn;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateActivityResponse build() {
            return new CreateActivityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
