/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a Lambda function scheduled during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionScheduledEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionScheduledEventDetails.Builder, LambdaFunctionScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(LambdaFunctionScheduledEventDetails::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(LambdaFunctionScheduledEventDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("inputDetails")
            .getter(getter(LambdaFunctionScheduledEventDetails::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeoutInSeconds").getter(getter(LambdaFunctionScheduledEventDetails::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final SdkField<TaskCredentials> TASK_CREDENTIALS_FIELD = SdkField
            .<TaskCredentials> builder(MarshallingType.SDK_POJO).memberName("taskCredentials")
            .getter(getter(LambdaFunctionScheduledEventDetails::taskCredentials)).setter(setter(Builder::taskCredentials))
            .constructor(TaskCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskCredentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, INPUT_FIELD,
            INPUT_DETAILS_FIELD, TIMEOUT_IN_SECONDS_FIELD, TASK_CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final String input;

    private final HistoryEventExecutionDataDetails inputDetails;

    private final Long timeoutInSeconds;

    private final TaskCredentials taskCredentials;

    private LambdaFunctionScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.taskCredentials = builder.taskCredentials;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scheduled Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scheduled Lambda function.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The JSON data input to the Lambda function. Length constraints apply to the payload size, and are expressed as
     * bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The JSON data input to the Lambda function. Length constraints apply to the payload size, and are
     *         expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Contains details about input for an execution history event.
     * </p>
     * 
     * @return Contains details about input for an execution history event.
     */
    public final HistoryEventExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The maximum allowed duration of the Lambda function.
     * </p>
     * 
     * @return The maximum allowed duration of the Lambda function.
     */
    public final Long timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The credentials that Step Functions uses for the task.
     * </p>
     * 
     * @return The credentials that Step Functions uses for the task.
     */
    public final TaskCredentials taskCredentials() {
        return taskCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(taskCredentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionScheduledEventDetails)) {
            return false;
        }
        LambdaFunctionScheduledEventDetails other = (LambdaFunctionScheduledEventDetails) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(input(), other.input())
                && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(taskCredentials(), other.taskCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionScheduledEventDetails").add("Resource", resource())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("TimeoutInSeconds", timeoutInSeconds()).add("TaskCredentials", taskCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "taskCredentials":
            return Optional.ofNullable(clazz.cast(taskCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("inputDetails", INPUT_DETAILS_FIELD);
        map.put("timeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("taskCredentials", TASK_CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionScheduledEventDetails, T> g) {
        return obj -> g.apply((LambdaFunctionScheduledEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionScheduledEventDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scheduled Lambda function.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the scheduled Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The JSON data input to the Lambda function. Length constraints apply to the payload size, and are expressed
         * as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The JSON data input to the Lambda function. Length constraints apply to the payload size, and are
         *        expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Contains details about input for an execution history event.
         * </p>
         * 
         * @param inputDetails
         *        Contains details about input for an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(HistoryEventExecutionDataDetails inputDetails);

        /**
         * <p>
         * Contains details about input for an execution history event.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The maximum allowed duration of the Lambda function.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The maximum allowed duration of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Long timeoutInSeconds);

        /**
         * <p>
         * The credentials that Step Functions uses for the task.
         * </p>
         * 
         * @param taskCredentials
         *        The credentials that Step Functions uses for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskCredentials(TaskCredentials taskCredentials);

        /**
         * <p>
         * The credentials that Step Functions uses for the task.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskCredentials.Builder} avoiding the
         * need to create one manually via {@link TaskCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #taskCredentials(TaskCredentials)}.
         * 
         * @param taskCredentials
         *        a consumer that will call methods on {@link TaskCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskCredentials(TaskCredentials)
         */
        default Builder taskCredentials(Consumer<TaskCredentials.Builder> taskCredentials) {
            return taskCredentials(TaskCredentials.builder().applyMutation(taskCredentials).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private String input;

        private HistoryEventExecutionDataDetails inputDetails;

        private Long timeoutInSeconds;

        private TaskCredentials taskCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionScheduledEventDetails model) {
            resource(model.resource);
            input(model.input);
            inputDetails(model.inputDetails);
            timeoutInSeconds(model.timeoutInSeconds);
            taskCredentials(model.taskCredentials);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final Long getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final TaskCredentials.Builder getTaskCredentials() {
            return taskCredentials != null ? taskCredentials.toBuilder() : null;
        }

        public final void setTaskCredentials(TaskCredentials.BuilderImpl taskCredentials) {
            this.taskCredentials = taskCredentials != null ? taskCredentials.build() : null;
        }

        @Override
        public final Builder taskCredentials(TaskCredentials taskCredentials) {
            this.taskCredentials = taskCredentials;
            return this;
        }

        @Override
        public LambdaFunctionScheduledEventDetails build() {
            return new LambdaFunctionScheduledEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
