/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IncludedData {
    ALL_DATA("ALL_DATA"),
    METADATA_ONLY("METADATA_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IncludedData> VALUE_MAP;
    private final String value;

    private IncludedData(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IncludedData fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IncludedData> knownValues() {
        EnumSet<IncludedData> knownValues = EnumSet.allOf(IncludedData.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IncludedData.class, IncludedData::toString);
    }
}

