/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnostic;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionDiagnosticListCopier;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResultCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateStateMachineDefinitionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ValidateStateMachineDefinitionResponse> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(ValidateStateMachineDefinitionResponse.getter(ValidateStateMachineDefinitionResponse::resultAsString)).setter(ValidateStateMachineDefinitionResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<List<ValidateStateMachineDefinitionDiagnostic>> DIAGNOSTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("diagnostics").getter(ValidateStateMachineDefinitionResponse.getter(ValidateStateMachineDefinitionResponse::diagnostics)).setter(ValidateStateMachineDefinitionResponse.setter(Builder::diagnostics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnostics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidateStateMachineDefinitionDiagnostic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("truncated").getter(ValidateStateMachineDefinitionResponse.getter(ValidateStateMachineDefinitionResponse::truncated)).setter(ValidateStateMachineDefinitionResponse.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, DIAGNOSTICS_FIELD, TRUNCATED_FIELD));
    private final String result;
    private final List<ValidateStateMachineDefinitionDiagnostic> diagnostics;
    private final Boolean truncated;

    private ValidateStateMachineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.diagnostics = builder.diagnostics;
        this.truncated = builder.truncated;
    }

    public final ValidateStateMachineDefinitionResultCode result() {
        return ValidateStateMachineDefinitionResultCode.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final boolean hasDiagnostics() {
        return this.diagnostics != null && !(this.diagnostics instanceof SdkAutoConstructList);
    }

    public final List<ValidateStateMachineDefinitionDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public final Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiagnostics() ? this.diagnostics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateStateMachineDefinitionResponse)) {
            return false;
        }
        ValidateStateMachineDefinitionResponse other = (ValidateStateMachineDefinitionResponse)((Object)obj);
        return Objects.equals(this.resultAsString(), other.resultAsString()) && this.hasDiagnostics() == other.hasDiagnostics() && Objects.equals(this.diagnostics(), other.diagnostics()) && Objects.equals(this.truncated(), other.truncated());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateStateMachineDefinitionResponse").add("Result", (Object)this.resultAsString()).add("Diagnostics", this.hasDiagnostics() ? this.diagnostics() : null).add("Truncated", (Object)this.truncated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "diagnostics": {
                return Optional.ofNullable(clazz.cast(this.diagnostics()));
            }
            case "truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateStateMachineDefinitionResponse, T> g) {
        return obj -> g.apply((ValidateStateMachineDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String result;
        private List<ValidateStateMachineDefinitionDiagnostic> diagnostics = DefaultSdkAutoConstructList.getInstance();
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateStateMachineDefinitionResponse model) {
            super(model);
            this.result(model.result);
            this.diagnostics(model.diagnostics);
            this.truncated(model.truncated);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ValidateStateMachineDefinitionResultCode result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final List<ValidateStateMachineDefinitionDiagnostic.Builder> getDiagnostics() {
            List<ValidateStateMachineDefinitionDiagnostic.Builder> result = ValidateStateMachineDefinitionDiagnosticListCopier.copyToBuilder(this.diagnostics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiagnostics(Collection<ValidateStateMachineDefinitionDiagnostic.BuilderImpl> diagnostics) {
            this.diagnostics = ValidateStateMachineDefinitionDiagnosticListCopier.copyFromBuilder(diagnostics);
        }

        @Override
        public final Builder diagnostics(Collection<ValidateStateMachineDefinitionDiagnostic> diagnostics) {
            this.diagnostics = ValidateStateMachineDefinitionDiagnosticListCopier.copy(diagnostics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diagnostics(ValidateStateMachineDefinitionDiagnostic ... diagnostics) {
            this.diagnostics(Arrays.asList(diagnostics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diagnostics(Consumer<ValidateStateMachineDefinitionDiagnostic.Builder> ... diagnostics) {
            this.diagnostics(Stream.of(diagnostics).map(c -> (ValidateStateMachineDefinitionDiagnostic)((ValidateStateMachineDefinitionDiagnostic.Builder)ValidateStateMachineDefinitionDiagnostic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        @Override
        public ValidateStateMachineDefinitionResponse build() {
            return new ValidateStateMachineDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateStateMachineDefinitionResponse> {
        public Builder result(String var1);

        public Builder result(ValidateStateMachineDefinitionResultCode var1);

        public Builder diagnostics(Collection<ValidateStateMachineDefinitionDiagnostic> var1);

        public Builder diagnostics(ValidateStateMachineDefinitionDiagnostic ... var1);

        public Builder diagnostics(Consumer<ValidateStateMachineDefinitionDiagnostic.Builder> ... var1);

        public Builder truncated(Boolean var1);
    }
}

