/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.InspectionDataRequest;
import software.amazon.awssdk.services.sfn.model.InspectionDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InspectionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InspectionData> {
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(InspectionData.getter(InspectionData::input)).setter(InspectionData.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> AFTER_INPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterInputPath").getter(InspectionData.getter(InspectionData::afterInputPath)).setter(InspectionData.setter(Builder::afterInputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterInputPath").build()}).build();
    private static final SdkField<String> AFTER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterParameters").getter(InspectionData.getter(InspectionData::afterParameters)).setter(InspectionData.setter(Builder::afterParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterParameters").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(InspectionData.getter(InspectionData::result)).setter(InspectionData.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> AFTER_RESULT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterResultSelector").getter(InspectionData.getter(InspectionData::afterResultSelector)).setter(InspectionData.setter(Builder::afterResultSelector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultSelector").build()}).build();
    private static final SdkField<String> AFTER_RESULT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterResultPath").getter(InspectionData.getter(InspectionData::afterResultPath)).setter(InspectionData.setter(Builder::afterResultPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultPath").build()}).build();
    private static final SdkField<InspectionDataRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(InspectionData.getter(InspectionData::request)).setter(InspectionData.setter(Builder::request)).constructor(InspectionDataRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()}).build();
    private static final SdkField<InspectionDataResponse> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("response").getter(InspectionData.getter(InspectionData::response)).setter(InspectionData.setter(Builder::response)).constructor(InspectionDataResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, AFTER_INPUT_PATH_FIELD, AFTER_PARAMETERS_FIELD, RESULT_FIELD, AFTER_RESULT_SELECTOR_FIELD, AFTER_RESULT_PATH_FIELD, REQUEST_FIELD, RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("input", INPUT_FIELD);
            this.put("afterInputPath", AFTER_INPUT_PATH_FIELD);
            this.put("afterParameters", AFTER_PARAMETERS_FIELD);
            this.put("result", RESULT_FIELD);
            this.put("afterResultSelector", AFTER_RESULT_SELECTOR_FIELD);
            this.put("afterResultPath", AFTER_RESULT_PATH_FIELD);
            this.put("request", REQUEST_FIELD);
            this.put("response", RESPONSE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String input;
    private final String afterInputPath;
    private final String afterParameters;
    private final String result;
    private final String afterResultSelector;
    private final String afterResultPath;
    private final InspectionDataRequest request;
    private final InspectionDataResponse response;

    private InspectionData(BuilderImpl builder) {
        this.input = builder.input;
        this.afterInputPath = builder.afterInputPath;
        this.afterParameters = builder.afterParameters;
        this.result = builder.result;
        this.afterResultSelector = builder.afterResultSelector;
        this.afterResultPath = builder.afterResultPath;
        this.request = builder.request;
        this.response = builder.response;
    }

    public final String input() {
        return this.input;
    }

    public final String afterInputPath() {
        return this.afterInputPath;
    }

    public final String afterParameters() {
        return this.afterParameters;
    }

    public final String result() {
        return this.result;
    }

    public final String afterResultSelector() {
        return this.afterResultSelector;
    }

    public final String afterResultPath() {
        return this.afterResultPath;
    }

    public final InspectionDataRequest request() {
        return this.request;
    }

    public final InspectionDataResponse response() {
        return this.response;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterInputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterResultSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterResultPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.response());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionData)) {
            return false;
        }
        InspectionData other = (InspectionData)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.afterInputPath(), other.afterInputPath()) && Objects.equals(this.afterParameters(), other.afterParameters()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.afterResultSelector(), other.afterResultSelector()) && Objects.equals(this.afterResultPath(), other.afterResultPath()) && Objects.equals(this.request(), other.request()) && Objects.equals(this.response(), other.response());
    }

    public final String toString() {
        return ToString.builder((String)"InspectionData").add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterInputPath", (Object)(this.afterInputPath() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterParameters", (Object)(this.afterParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Result", (Object)(this.result() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterResultSelector", (Object)(this.afterResultSelector() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterResultPath", (Object)(this.afterResultPath() == null ? null : "*** Sensitive Data Redacted ***")).add("Request", (Object)this.request()).add("Response", (Object)this.response()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "afterInputPath": {
                return Optional.ofNullable(clazz.cast(this.afterInputPath()));
            }
            case "afterParameters": {
                return Optional.ofNullable(clazz.cast(this.afterParameters()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "afterResultSelector": {
                return Optional.ofNullable(clazz.cast(this.afterResultSelector()));
            }
            case "afterResultPath": {
                return Optional.ofNullable(clazz.cast(this.afterResultPath()));
            }
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "response": {
                return Optional.ofNullable(clazz.cast(this.response()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InspectionData, T> g) {
        return obj -> g.apply((InspectionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String input;
        private String afterInputPath;
        private String afterParameters;
        private String result;
        private String afterResultSelector;
        private String afterResultPath;
        private InspectionDataRequest request;
        private InspectionDataResponse response;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionData model) {
            this.input(model.input);
            this.afterInputPath(model.afterInputPath);
            this.afterParameters(model.afterParameters);
            this.result(model.result);
            this.afterResultSelector(model.afterResultSelector);
            this.afterResultPath(model.afterResultPath);
            this.request(model.request);
            this.response(model.response);
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getAfterInputPath() {
            return this.afterInputPath;
        }

        public final void setAfterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
        }

        @Override
        public final Builder afterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
            return this;
        }

        public final String getAfterParameters() {
            return this.afterParameters;
        }

        public final void setAfterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
        }

        @Override
        public final Builder afterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final String getAfterResultSelector() {
            return this.afterResultSelector;
        }

        public final void setAfterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
        }

        @Override
        public final Builder afterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
            return this;
        }

        public final String getAfterResultPath() {
            return this.afterResultPath;
        }

        public final void setAfterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
        }

        @Override
        public final Builder afterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
            return this;
        }

        public final InspectionDataRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(InspectionDataRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(InspectionDataRequest request) {
            this.request = request;
            return this;
        }

        public final InspectionDataResponse.Builder getResponse() {
            return this.response != null ? this.response.toBuilder() : null;
        }

        public final void setResponse(InspectionDataResponse.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(InspectionDataResponse response) {
            this.response = response;
            return this;
        }

        public InspectionData build() {
            return new InspectionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InspectionData> {
        public Builder input(String var1);

        public Builder afterInputPath(String var1);

        public Builder afterParameters(String var1);

        public Builder result(String var1);

        public Builder afterResultSelector(String var1);

        public Builder afterResultPath(String var1);

        public Builder request(InspectionDataRequest var1);

        default public Builder request(Consumer<InspectionDataRequest.Builder> request) {
            return this.request((InspectionDataRequest)((InspectionDataRequest.Builder)InspectionDataRequest.builder().applyMutation(request)).build());
        }

        public Builder response(InspectionDataResponse var1);

        default public Builder response(Consumer<InspectionDataResponse.Builder> response) {
            return this.response((InspectionDataResponse)((InspectionDataResponse.Builder)InspectionDataResponse.builder().applyMutation(response)).build());
        }
    }
}

