/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskTimedOutEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskTimedOutEventDetails> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(TaskTimedOutEventDetails.getter(TaskTimedOutEventDetails::resourceType)).setter(TaskTimedOutEventDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(TaskTimedOutEventDetails.getter(TaskTimedOutEventDetails::resource)).setter(TaskTimedOutEventDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(TaskTimedOutEventDetails.getter(TaskTimedOutEventDetails::error)).setter(TaskTimedOutEventDetails.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cause").getter(TaskTimedOutEventDetails.getter(TaskTimedOutEventDetails::cause)).setter(TaskTimedOutEventDetails.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_FIELD, ERROR_FIELD, CAUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String resource;
    private final String error;
    private final String causeValue;

    private TaskTimedOutEventDetails(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resource() {
        return this.resource;
    }

    public final String error() {
        return this.error;
    }

    public final String cause() {
        return this.causeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTimedOutEventDetails)) {
            return false;
        }
        TaskTimedOutEventDetails other = (TaskTimedOutEventDetails)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.cause(), other.cause());
    }

    public final String toString() {
        return ToString.builder((String)"TaskTimedOutEventDetails").add("ResourceType", (Object)this.resourceType()).add("Resource", (Object)this.resource()).add("Error", (Object)(this.error() == null ? null : "*** Sensitive Data Redacted ***")).add("Cause", (Object)(this.cause() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskTimedOutEventDetails, T> g) {
        return obj -> g.apply((TaskTimedOutEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resource;
        private String error;
        private String causeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTimedOutEventDetails model) {
            this.resourceType(model.resourceType);
            this.resource(model.resource);
            this.error(model.error);
            this.cause(model.causeValue);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getCause() {
            return this.causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        @Transient
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public TaskTimedOutEventDetails build() {
            return new TaskTimedOutEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskTimedOutEventDetails> {
        public Builder resourceType(String var1);

        public Builder resource(String var1);

        public Builder error(String var1);

        public Builder cause(String var1);
    }
}

