/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivityScheduledEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivityScheduledEventDetails> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(ActivityScheduledEventDetails.getter(ActivityScheduledEventDetails::resource)).setter(ActivityScheduledEventDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(ActivityScheduledEventDetails.getter(ActivityScheduledEventDetails::input)).setter(ActivityScheduledEventDetails.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDetails").getter(ActivityScheduledEventDetails.getter(ActivityScheduledEventDetails::inputDetails)).setter(ActivityScheduledEventDetails.setter(Builder::inputDetails)).constructor(HistoryEventExecutionDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()}).build();
    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("timeoutInSeconds").getter(ActivityScheduledEventDetails.getter(ActivityScheduledEventDetails::timeoutInSeconds)).setter(ActivityScheduledEventDetails.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()}).build();
    private static final SdkField<Long> HEARTBEAT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("heartbeatInSeconds").getter(ActivityScheduledEventDetails.getter(ActivityScheduledEventDetails::heartbeatInSeconds)).setter(ActivityScheduledEventDetails.setter(Builder::heartbeatInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heartbeatInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, INPUT_FIELD, INPUT_DETAILS_FIELD, TIMEOUT_IN_SECONDS_FIELD, HEARTBEAT_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resource;
    private final String input;
    private final HistoryEventExecutionDataDetails inputDetails;
    private final Long timeoutInSeconds;
    private final Long heartbeatInSeconds;

    private ActivityScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.heartbeatInSeconds = builder.heartbeatInSeconds;
    }

    public final String resource() {
        return this.resource;
    }

    public final String input() {
        return this.input;
    }

    public final HistoryEventExecutionDataDetails inputDetails() {
        return this.inputDetails;
    }

    public final Long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final Long heartbeatInSeconds() {
        return this.heartbeatInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityScheduledEventDetails)) {
            return false;
        }
        ActivityScheduledEventDetails other = (ActivityScheduledEventDetails)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.inputDetails(), other.inputDetails()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.heartbeatInSeconds(), other.heartbeatInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ActivityScheduledEventDetails").add("Resource", (Object)this.resource()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("InputDetails", (Object)this.inputDetails()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("HeartbeatInSeconds", (Object)this.heartbeatInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "inputDetails": {
                return Optional.ofNullable(clazz.cast(this.inputDetails()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "heartbeatInSeconds": {
                return Optional.ofNullable(clazz.cast(this.heartbeatInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivityScheduledEventDetails, T> g) {
        return obj -> g.apply((ActivityScheduledEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private String input;
        private HistoryEventExecutionDataDetails inputDetails;
        private Long timeoutInSeconds;
        private Long heartbeatInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityScheduledEventDetails model) {
            this.resource(model.resource);
            this.input(model.input);
            this.inputDetails(model.inputDetails);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.heartbeatInSeconds(model.heartbeatInSeconds);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return this.inputDetails != null ? this.inputDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        public final Long getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Long getHeartbeatInSeconds() {
            return this.heartbeatInSeconds;
        }

        @Override
        public final Builder heartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
            return this;
        }

        public final void setHeartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
        }

        public ActivityScheduledEventDetails build() {
            return new ActivityScheduledEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivityScheduledEventDetails> {
        public Builder resource(String var1);

        public Builder input(String var1);

        public Builder inputDetails(HistoryEventExecutionDataDetails var1);

        default public Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return this.inputDetails((HistoryEventExecutionDataDetails)((HistoryEventExecutionDataDetails.Builder)HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails)).build());
        }

        public Builder timeoutInSeconds(Long var1);

        public Builder heartbeatInSeconds(Long var1);
    }
}

