/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> STATEMACHINEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateMachineArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> INPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("input").isBinary(false).build();
    private static final StartExecutionRequestModelMarshaller INSTANCE = new StartExecutionRequestModelMarshaller();

    private StartExecutionRequestModelMarshaller() {
    }

    public static StartExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartExecutionRequest startExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startExecutionRequest), (String)"startExecutionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startExecutionRequest.stateMachineArn(), STATEMACHINEARN_BINDING);
            protocolMarshaller.marshall((Object)startExecutionRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)startExecutionRequest.input(), INPUT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

