/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.transform.SendTaskSuccessRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SendTaskSuccessRequestMarshaller
implements Marshaller<Request<SendTaskSuccessRequest>, SendTaskSuccessRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSStepFunctions.SendTaskSuccess").serviceName("AWS SFN").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public SendTaskSuccessRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SendTaskSuccessRequest> marshall(SendTaskSuccessRequest sendTaskSuccessRequest) {
        Validate.paramNotNull((Object)((Object)sendTaskSuccessRequest), (String)"sendTaskSuccessRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)sendTaskSuccessRequest);
            protocolMarshaller.startMarshalling();
            SendTaskSuccessRequestModelMarshaller.getInstance().marshall(sendTaskSuccessRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

