/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListExecutionsRequestModelMarshaller {
    private static final MarshallingInfo<String> STATEMACHINEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateMachineArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusFilter").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final ListExecutionsRequestModelMarshaller INSTANCE = new ListExecutionsRequestModelMarshaller();

    private ListExecutionsRequestModelMarshaller() {
    }

    public static ListExecutionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListExecutionsRequest listExecutionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listExecutionsRequest), (String)"listExecutionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listExecutionsRequest.stateMachineArn(), STATEMACHINEARN_BINDING);
            protocolMarshaller.marshall((Object)listExecutionsRequest.statusFilterAsString(), STATUSFILTER_BINDING);
            protocolMarshaller.marshall((Object)listExecutionsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listExecutionsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

