/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sfn.model.HistoryEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HistoryEventMarshaller {
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Long> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<Long> PREVIOUSEVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousEventId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSCHEDULEFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityScheduleFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSCHEDULEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityScheduledEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSTARTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityStartedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activitySucceededEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVITYTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityTimedOutEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSTARTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStartedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionSucceededEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONABORTEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionAbortedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionTimedOutEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionScheduleFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSCHEDULEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionScheduledEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSTARTFAILEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionStartFailedEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONSUCCEEDEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionSucceededEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDAFUNCTIONTIMEDOUTEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaFunctionTimedOutEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATEENTEREDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateEnteredEventDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATEEXITEDEVENTDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateExitedEventDetails").isBinary(false).build();
    private static final HistoryEventMarshaller INSTANCE = new HistoryEventMarshaller();

    private HistoryEventMarshaller() {
    }

    public static HistoryEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HistoryEvent historyEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)historyEvent, (String)"historyEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)historyEvent.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.previousEventId(), PREVIOUSEVENTID_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityFailedEventDetails(), ACTIVITYFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityScheduleFailedEventDetails(), ACTIVITYSCHEDULEFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityScheduledEventDetails(), ACTIVITYSCHEDULEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityStartedEventDetails(), ACTIVITYSTARTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activitySucceededEventDetails(), ACTIVITYSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.activityTimedOutEventDetails(), ACTIVITYTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.executionFailedEventDetails(), EXECUTIONFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.executionStartedEventDetails(), EXECUTIONSTARTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.executionSucceededEventDetails(), EXECUTIONSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.executionAbortedEventDetails(), EXECUTIONABORTEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.executionTimedOutEventDetails(), EXECUTIONTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionFailedEventDetails(), LAMBDAFUNCTIONFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionScheduleFailedEventDetails(), LAMBDAFUNCTIONSCHEDULEFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionScheduledEventDetails(), LAMBDAFUNCTIONSCHEDULEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionStartFailedEventDetails(), LAMBDAFUNCTIONSTARTFAILEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionSucceededEventDetails(), LAMBDAFUNCTIONSUCCEEDEDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.lambdaFunctionTimedOutEventDetails(), LAMBDAFUNCTIONTIMEDOUTEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.stateEnteredEventDetails(), STATEENTEREDEVENTDETAILS_BINDING);
            protocolMarshaller.marshall((Object)historyEvent.stateExitedEventDetails(), STATEEXITEDEVENTDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

