/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetActivityTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> ACTIVITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityArn").isBinary(false).build();
    private static final MarshallingInfo<String> WORKERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workerName").isBinary(false).build();
    private static final GetActivityTaskRequestModelMarshaller INSTANCE = new GetActivityTaskRequestModelMarshaller();

    private GetActivityTaskRequestModelMarshaller() {
    }

    public static GetActivityTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetActivityTaskRequest getActivityTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getActivityTaskRequest), (String)"getActivityTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getActivityTaskRequest.activityArn(), ACTIVITYARN_BINDING);
            protocolMarshaller.marshall((Object)getActivityTaskRequest.workerName(), WORKERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

