/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.ExecutionListItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExecutionListItemMarshaller {
    private static final MarshallingInfo<String> EXECUTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATEMACHINEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateMachineArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> STOPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopDate").isBinary(false).build();
    private static final ExecutionListItemMarshaller INSTANCE = new ExecutionListItemMarshaller();

    private ExecutionListItemMarshaller() {
    }

    public static ExecutionListItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExecutionListItem executionListItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)executionListItem, (String)"executionListItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)executionListItem.executionArn(), EXECUTIONARN_BINDING);
            protocolMarshaller.marshall((Object)executionListItem.stateMachineArn(), STATEMACHINEARN_BINDING);
            protocolMarshaller.marshall((Object)executionListItem.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)executionListItem.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)executionListItem.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)executionListItem.stopDate(), STOPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

