/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> EXECUTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionArn").isBinary(false).build();
    private static final DescribeExecutionRequestModelMarshaller INSTANCE = new DescribeExecutionRequestModelMarshaller();

    private DescribeExecutionRequestModelMarshaller() {
    }

    public static DescribeExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeExecutionRequest describeExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeExecutionRequest), (String)"describeExecutionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeExecutionRequest.executionArn(), EXECUTIONARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

