/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sfn.model.ActivityListItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActivityListItemMarshaller {
    private static final MarshallingInfo<String> ACTIVITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activityArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final ActivityListItemMarshaller INSTANCE = new ActivityListItemMarshaller();

    private ActivityListItemMarshaller() {
    }

    public static ActivityListItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActivityListItem activityListItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activityListItem, (String)"activityListItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activityListItem.activityArn(), ACTIVITYARN_BINDING);
            protocolMarshaller.marshall((Object)activityListItem.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)activityListItem.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

