/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopExecutionRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, StopExecutionRequest> {
    private final String executionArn;
    private final String error;
    private final String cause;

    private StopExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.error = builder.error;
        this.cause = builder.cause;
    }

    public String executionArn() {
        return this.executionArn;
    }

    public String error() {
        return this.error;
    }

    public String cause() {
        return this.cause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopExecutionRequest)) {
            return false;
        }
        StopExecutionRequest other = (StopExecutionRequest)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.cause(), other.cause());
    }

    public String toString() {
        return ToString.builder((String)"StopExecutionRequest").add("ExecutionArn", (Object)this.executionArn()).add("Error", (Object)this.error()).add("Cause", (Object)this.cause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String executionArn;
        private String error;
        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(StopExecutionRequest model) {
            super(model);
            this.executionArn(model.executionArn);
            this.error(model.error);
            this.cause(model.cause);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getCause() {
            return this.cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopExecutionRequest build() {
            return new StopExecutionRequest(this);
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    CopyableBuilder<Builder, StopExecutionRequest> {
        public Builder executionArn(String var1);

        public Builder error(String var1);

        public Builder cause(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

