/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExecutionResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, StartExecutionResponse> {
    private final String executionArn;
    private final Instant startDate;

    private StartExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.startDate = builder.startDate;
    }

    public String executionArn() {
        return this.executionArn;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionResponse)) {
            return false;
        }
        StartExecutionResponse other = (StartExecutionResponse)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.startDate(), other.startDate());
    }

    public String toString() {
        return ToString.builder((String)"StartExecutionResponse").add("ExecutionArn", (Object)this.executionArn()).add("StartDate", (Object)this.startDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String executionArn;
        private Instant startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionResponse model) {
            super(model);
            this.executionArn(model.executionArn);
            this.startDate(model.startDate);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public StartExecutionResponse build() {
            return new StartExecutionResponse(this);
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    CopyableBuilder<Builder, StartExecutionResponse> {
        public Builder executionArn(String var1);

        public Builder startDate(Instant var1);
    }
}

