/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineListCopier;
import software.amazon.awssdk.services.sfn.model.StateMachineListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStateMachinesResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListStateMachinesResponse> {
    private final List<StateMachineListItem> stateMachines;
    private final String nextToken;

    private ListStateMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachines = builder.stateMachines;
        this.nextToken = builder.nextToken;
    }

    public List<StateMachineListItem> stateMachines() {
        return this.stateMachines;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachines());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachinesResponse)) {
            return false;
        }
        ListStateMachinesResponse other = (ListStateMachinesResponse)((Object)obj);
        return Objects.equals(this.stateMachines(), other.stateMachines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStateMachinesResponse").add("StateMachines", this.stateMachines()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachines": {
                return Optional.ofNullable(clazz.cast(this.stateMachines()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<StateMachineListItem> stateMachines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachinesResponse model) {
            super(model);
            this.stateMachines(model.stateMachines);
            this.nextToken(model.nextToken);
        }

        public final Collection<StateMachineListItem.Builder> getStateMachines() {
            return this.stateMachines != null ? (Collection)this.stateMachines.stream().map(StateMachineListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stateMachines(Collection<StateMachineListItem> stateMachines) {
            this.stateMachines = StateMachineListCopier.copy(stateMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(StateMachineListItem ... stateMachines) {
            this.stateMachines(Arrays.asList(stateMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(Consumer<StateMachineListItem.Builder> ... stateMachines) {
            this.stateMachines(Stream.of(stateMachines).map(c -> (StateMachineListItem)((StateMachineListItem.Builder)StateMachineListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStateMachines(Collection<StateMachineListItem.BuilderImpl> stateMachines) {
            this.stateMachines = StateMachineListCopier.copyFromBuilder(stateMachines);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStateMachinesResponse build() {
            return new ListStateMachinesResponse(this);
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    CopyableBuilder<Builder, ListStateMachinesResponse> {
        public Builder stateMachines(Collection<StateMachineListItem> var1);

        public Builder stateMachines(StateMachineListItem ... var1);

        public Builder stateMachines(Consumer<StateMachineListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

