/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.ActivityListCopier;
import software.amazon.awssdk.services.sfn.model.ActivityListItem;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActivitiesResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListActivitiesResponse> {
    private final List<ActivityListItem> activities;
    private final String nextToken;

    private ListActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    public List<ActivityListItem> activities() {
        return this.activities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivitiesResponse)) {
            return false;
        }
        ListActivitiesResponse other = (ListActivitiesResponse)((Object)obj);
        return Objects.equals(this.activities(), other.activities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListActivitiesResponse").add("Activities", this.activities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activities": {
                return Optional.ofNullable(clazz.cast(this.activities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<ActivityListItem> activities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivitiesResponse model) {
            super(model);
            this.activities(model.activities);
            this.nextToken(model.nextToken);
        }

        public final Collection<ActivityListItem.Builder> getActivities() {
            return this.activities != null ? (Collection)this.activities.stream().map(ActivityListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<ActivityListItem> activities) {
            this.activities = ActivityListCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(ActivityListItem ... activities) {
            this.activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<ActivityListItem.Builder> ... activities) {
            this.activities(Stream.of(activities).map(c -> (ActivityListItem)((ActivityListItem.Builder)ActivityListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActivities(Collection<ActivityListItem.BuilderImpl> activities) {
            this.activities = ActivityListCopier.copyFromBuilder(activities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActivitiesResponse build() {
            return new ListActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    CopyableBuilder<Builder, ListActivitiesResponse> {
        public Builder activities(Collection<ActivityListItem> var1);

        public Builder activities(ActivityListItem ... var1);

        public Builder activities(Consumer<ActivityListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

