/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sfn.transform.LambdaFunctionScheduledEventDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionScheduledEventDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, LambdaFunctionScheduledEventDetails> {
    private final String resource;
    private final String input;
    private final Long timeoutInSeconds;

    private LambdaFunctionScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.timeoutInSeconds = builder.timeoutInSeconds;
    }

    public String resource() {
        return this.resource;
    }

    public String input() {
        return this.input;
    }

    public Long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionScheduledEventDetails)) {
            return false;
        }
        LambdaFunctionScheduledEventDetails other = (LambdaFunctionScheduledEventDetails)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"LambdaFunctionScheduledEventDetails").add("Resource", (Object)this.resource()).add("Input", (Object)this.input()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionScheduledEventDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private String input;
        private Long timeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionScheduledEventDetails model) {
            this.resource(model.resource);
            this.input(model.input);
            this.timeoutInSeconds(model.timeoutInSeconds);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final Long getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public LambdaFunctionScheduledEventDetails build() {
            return new LambdaFunctionScheduledEventDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaFunctionScheduledEventDetails> {
        public Builder resource(String var1);

        public Builder input(String var1);

        public Builder timeoutInSeconds(Long var1);
    }
}

