/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExecutionHistoryRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, GetExecutionHistoryRequest> {
    private final String executionArn;
    private final Integer maxResults;
    private final Boolean reverseOrder;
    private final String nextToken;

    private GetExecutionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.maxResults = builder.maxResults;
        this.reverseOrder = builder.reverseOrder;
        this.nextToken = builder.nextToken;
    }

    public String executionArn() {
        return this.executionArn;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionHistoryRequest)) {
            return false;
        }
        GetExecutionHistoryRequest other = (GetExecutionHistoryRequest)((Object)obj);
        return Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetExecutionHistoryRequest").add("ExecutionArn", (Object)this.executionArn()).add("MaxResults", (Object)this.maxResults()).add("ReverseOrder", (Object)this.reverseOrder()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String executionArn;
        private Integer maxResults;
        private Boolean reverseOrder;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionHistoryRequest model) {
            super(model);
            this.executionArn(model.executionArn);
            this.maxResults(model.maxResults);
            this.reverseOrder(model.reverseOrder);
            this.nextToken(model.nextToken);
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExecutionHistoryRequest build() {
            return new GetExecutionHistoryRequest(this);
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    CopyableBuilder<Builder, GetExecutionHistoryRequest> {
        public Builder executionArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

