/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetActivityTaskRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, GetActivityTaskRequest> {
    private final String activityArn;
    private final String workerName;

    private GetActivityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.workerName = builder.workerName;
    }

    public String activityArn() {
        return this.activityArn;
    }

    public String workerName() {
        return this.workerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActivityTaskRequest)) {
            return false;
        }
        GetActivityTaskRequest other = (GetActivityTaskRequest)((Object)obj);
        return Objects.equals(this.activityArn(), other.activityArn()) && Objects.equals(this.workerName(), other.workerName());
    }

    public String toString() {
        return ToString.builder((String)"GetActivityTaskRequest").add("ActivityArn", (Object)this.activityArn()).add("WorkerName", (Object)this.workerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityArn": {
                return Optional.ofNullable(clazz.cast(this.activityArn()));
            }
            case "workerName": {
                return Optional.ofNullable(clazz.cast(this.workerName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String activityArn;
        private String workerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActivityTaskRequest model) {
            super(model);
            this.activityArn(model.activityArn);
            this.workerName(model.workerName);
        }

        public final String getActivityArn() {
            return this.activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        public final String getWorkerName() {
            return this.workerName;
        }

        @Override
        public final Builder workerName(String workerName) {
            this.workerName = workerName;
            return this;
        }

        public final void setWorkerName(String workerName) {
            this.workerName = workerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetActivityTaskRequest build() {
            return new GetActivityTaskRequest(this);
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    CopyableBuilder<Builder, GetActivityTaskRequest> {
        public Builder activityArn(String var1);

        public Builder workerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

