/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActivityResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, CreateActivityResponse> {
    private final String activityArn;
    private final Instant creationDate;

    private CreateActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.creationDate = builder.creationDate;
    }

    public String activityArn() {
        return this.activityArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivityResponse)) {
            return false;
        }
        CreateActivityResponse other = (CreateActivityResponse)((Object)obj);
        return Objects.equals(this.activityArn(), other.activityArn()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"CreateActivityResponse").add("ActivityArn", (Object)this.activityArn()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityArn": {
                return Optional.ofNullable(clazz.cast(this.activityArn()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String activityArn;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivityResponse model) {
            super(model);
            this.activityArn(model.activityArn);
            this.creationDate(model.creationDate);
        }

        public final String getActivityArn() {
            return this.activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public CreateActivityResponse build() {
            return new CreateActivityResponse(this);
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    CopyableBuilder<Builder, CreateActivityResponse> {
        public Builder activityArn(String var1);

        public Builder creationDate(Instant var1);
    }
}

