/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sfn.transform.ActivityScheduledEventDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivityScheduledEventDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ActivityScheduledEventDetails> {
    private final String resource;
    private final String input;
    private final Long timeoutInSeconds;
    private final Long heartbeatInSeconds;

    private ActivityScheduledEventDetails(BuilderImpl builder) {
        this.resource = builder.resource;
        this.input = builder.input;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.heartbeatInSeconds = builder.heartbeatInSeconds;
    }

    public String resource() {
        return this.resource;
    }

    public String input() {
        return this.input;
    }

    public Long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Long heartbeatInSeconds() {
        return this.heartbeatInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityScheduledEventDetails)) {
            return false;
        }
        ActivityScheduledEventDetails other = (ActivityScheduledEventDetails)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.heartbeatInSeconds(), other.heartbeatInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"ActivityScheduledEventDetails").add("Resource", (Object)this.resource()).add("Input", (Object)this.input()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("HeartbeatInSeconds", (Object)this.heartbeatInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "heartbeatInSeconds": {
                return Optional.ofNullable(clazz.cast(this.heartbeatInSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityScheduledEventDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private String input;
        private Long timeoutInSeconds;
        private Long heartbeatInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityScheduledEventDetails model) {
            this.resource(model.resource);
            this.input(model.input);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.heartbeatInSeconds(model.heartbeatInSeconds);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final Long getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Long getHeartbeatInSeconds() {
            return this.heartbeatInSeconds;
        }

        @Override
        public final Builder heartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
            return this;
        }

        public final void setHeartbeatInSeconds(Long heartbeatInSeconds) {
            this.heartbeatInSeconds = heartbeatInSeconds;
        }

        public ActivityScheduledEventDetails build() {
            return new ActivityScheduledEventDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivityScheduledEventDetails> {
        public Builder resource(String var1);

        public Builder input(String var1);

        public Builder timeoutInSeconds(Long var1);

        public Builder heartbeatInSeconds(Long var1);
    }
}

