/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Date;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.sfn.builder.states.StateVisitor;
import software.amazon.awssdk.services.sfn.builder.states.Transition;
import software.amazon.awssdk.services.sfn.builder.states.TransitionState;
import software.amazon.awssdk.services.sfn.builder.states.TransitionStateBuilder;
import software.amazon.awssdk.services.sfn.builder.states.WaitFor;
import software.amazon.awssdk.services.sfn.builder.states.WaitForSeconds;
import software.amazon.awssdk.services.sfn.builder.states.WaitForSecondsPath;
import software.amazon.awssdk.services.sfn.builder.states.WaitForTimestamp;
import software.amazon.awssdk.services.sfn.builder.states.WaitForTimestampPath;

@SdkPublicApi
public final class WaitState
extends TransitionState {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonUnwrapped
    private final WaitFor waitFor;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;
    @JsonUnwrapped
    private final Transition transition;

    @JsonCreator
    private WaitState(Builder builder) {
        this.comment = builder.comment;
        this.waitFor = (WaitFor)builder.waitFor.build();
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.transition = (Transition)builder.transition.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return "Wait";
    }

    public String getComment() {
        return this.comment;
    }

    public WaitFor getWaitFor() {
        return this.waitFor;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static final class Builder
    extends TransitionStateBuilder {
        @JsonProperty(value="Comment")
        private String comment;
        private WaitFor.Builder waitFor = WaitFor.NULL_BUILDER;
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;
        @JsonProperty
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="Seconds")
        private Builder seconds(Integer seconds) {
            return this.waitFor(WaitForSeconds.builder().seconds(seconds));
        }

        @JsonProperty(value="Timestamp")
        private Builder timestamp(Date timestamp) {
            return this.waitFor(WaitForTimestamp.builder().timestamp(timestamp));
        }

        @JsonProperty(value="TimestampPath")
        private Builder timestampPath(String timestampPath) {
            return this.waitFor(WaitForTimestampPath.builder().timestampPath(timestampPath));
        }

        @JsonProperty(value="SecondsPath")
        private Builder secondsPath(String secondsPath) {
            return this.waitFor(WaitForSecondsPath.builder().secondsPath(secondsPath));
        }

        public Builder waitFor(WaitFor.Builder waitFor) {
            this.waitFor = waitFor;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        @Override
        public Builder transition(Transition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public WaitState build() {
            return new WaitState(this);
        }
    }
}

