/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.states;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.sfn.builder.internal.Buildable;

@SdkPublicApi
public final class Retrier {
    @JsonProperty(value="ErrorEquals")
    private final List<String> errorEquals;
    @JsonProperty(value="IntervalSeconds")
    private final Integer intervalSeconds;
    @JsonProperty(value="MaxAttempts")
    private final Integer maxAttempts;
    @JsonProperty(value="BackoffRate")
    private final Double backoffRate;

    private Retrier(Builder builder) {
        this.errorEquals = new ArrayList<String>(builder.errorEquals);
        this.intervalSeconds = builder.intervalSeconds;
        this.maxAttempts = builder.maxAttempts;
        this.backoffRate = builder.backoffRate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getErrorEquals() {
        return this.errorEquals;
    }

    public Integer getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public Double getBackoffRate() {
        return this.backoffRate;
    }

    public static final class Builder
    implements Buildable<Retrier> {
        @JsonProperty(value="ErrorEquals")
        private List<String> errorEquals = new ArrayList<String>();
        @JsonProperty(value="IntervalSeconds")
        private Integer intervalSeconds;
        @JsonProperty(value="MaxAttempts")
        private Integer maxAttempts;
        @JsonProperty(value="BackoffRate")
        private Double backoffRate;

        private Builder() {
        }

        public Builder errorEquals(String ... errorEquals) {
            Collections.addAll(this.errorEquals, errorEquals);
            return this;
        }

        public Builder retryOnAllErrors() {
            this.errorEquals.clear();
            this.errorEquals("States.ALL");
            return this;
        }

        public Builder intervalSeconds(Integer intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder backoffRate(Double backoffRate) {
            this.backoffRate = backoffRate;
            return this;
        }

        @Override
        public Retrier build() {
            return new Retrier(this);
        }
    }
}

