/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.states;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sfn.builder.states.StateVisitor;
import software.amazon.awssdk.services.sfn.builder.states.Transition;
import software.amazon.awssdk.services.sfn.builder.states.TransitionState;
import software.amazon.awssdk.services.sfn.builder.states.TransitionStateBuilder;

@SdkPublicApi
public final class PassState
extends TransitionState {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS}).disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS}).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="Result")
    private final JsonNode result;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;
    @JsonProperty(value="ResultPath")
    private final String resultPath;
    @JsonUnwrapped
    private final Transition transition;

    private PassState(Builder builder) {
        this.comment = builder.comment;
        this.result = builder.result;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.resultPath = builder.resultPath;
        this.transition = (Transition)builder.transition.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return "Pass";
    }

    public String getComment() {
        return this.comment;
    }

    @JsonIgnore
    public String getResult() {
        try {
            return this.result == null ? null : MAPPER.writeValueAsString((Object)this.result);
        }
        catch (JsonProcessingException e) {
            throw SdkClientException.builder().message("Could not serialize result").cause((Throwable)e).build();
        }
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static final class Builder
    extends TransitionStateBuilder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="Result")
        private JsonNode result;
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;
        @JsonProperty(value="ResultPath")
        private String resultPath;
        private Transition.Builder transition = Transition.NULL_BUILDER;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder result(Object result) {
            this.result = MAPPER.valueToTree(result);
            return this;
        }

        public Builder result(String result) {
            try {
                this.result = MAPPER.readTree(result);
            }
            catch (IOException e) {
                throw SdkClientException.builder().message("Result must be a JSON document").cause((Throwable)e).build();
            }
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        @Override
        public Builder transition(Transition.Builder transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public PassState build() {
            return new PassState(this);
        }
    }
}

