/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.internal.validation;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sfn.builder.internal.validation.Problem;
import software.amazon.awssdk.services.sfn.builder.internal.validation.ValidationException;

@SdkInternalApi
final class ProblemReporter {
    private final List<Problem> problems = new ArrayList<Problem>();

    ProblemReporter() {
    }

    public void report(Problem problem) {
        this.problems.add(problem);
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public ValidationException getException() {
        StringBuilder exceptionMessage = new StringBuilder();
        for (Problem problem : this.problems) {
            exceptionMessage.append(String.format("\n%s: %s", problem.getContext().getPath(), problem.getMessage()));
        }
        return new ValidationException(exceptionMessage.toString());
    }
}

